#!/usr/bin/python

import gevent
from gevent.server import StreamServer
from gevent.pool import Pool
import socket
import threading
import SocketServer
import BaseHTTPServer

import system


# ==============================================================================================================


MAXCONCURRENTCONNECTIONS = 10


# ==============================================================================================================


def DefaultTCPRequestHandler(Socket, Address):
    system.Log("Connection from %s:%d" % (Address[0], Address[1]))
    Data = Socket.recv(1024)
    Socket.sendall("Hi!\n")
    Socket.close()


def DefaultHttpRequestHandler(HTTPRequestHandler):
    HTTPRequestHandler.send_response(200)
    HTTPRequestHandler.send_header("Connection", "Close")
    HTTPRequestHandler.end_headers()
    HTTPRequestHandler.wfile.write("Hi!\n")


def DefaultHttpLogger(Fmt, *Args):
    system.Log(Fmt % Args)


# ==============================================================================================================



def NetServer(RequestHandler=DefaultTCPRequestHandler,
              IP="127.0.0.1",
              Port=8080,
              MaxConcurrentConnections=MAXCONCURRENTCONNECTIONS,
              Threaded=False,
              Name=None):

    class ThreadingMixIn:
        def process_request(self, request, client_address):
            T = threading.Thread(target=self.process_request_thread, args=(request, client_address), name=threading.current_thread().name)
            T.daemon = self.daemon_threads
            T.start()

    class ThreadedTCPServer(ThreadingMixIn, SocketServer.ThreadingMixIn, SocketServer.TCPServer):
        daemon_threads      = True
        allow_reuse_address = True
        request_queue_size  = MaxConcurrentConnections
        address_family      = socket.AF_INET6 if system.isIPv6(IP) else socket.AF_INET

    class TCPRequestHandler(SocketServer.BaseRequestHandler):
        def handle(self):
            RequestHandler(self.request, self.client_address)

    if Threaded:
        TCP = ThreadedTCPServer((IP, Port), TCPRequestHandler)
        Name = threading.current_thread().name if None else Name
        Server = threading.Thread(target=TCP.serve_forever, name=Name)
        Server.daemon = True
        Server.start()
    else:
        Server = StreamServer((IP, Port), RequestHandler, spawn=Pool(MaxConcurrentConnections))
        Server.start()


# ==============================================================================================================


def HttpServer(GetHandler=DefaultHttpRequestHandler,
               PostHandler=DefaultHttpRequestHandler,
               IP="127.0.0.1",
               Port=8080,
               MaxConcurrentConnections=MAXCONCURRENTCONNECTIONS,
               Threaded=False,
               Name=None,
               HttpLogger=DefaultHttpLogger):

    class HTTPRequestHandler(BaseHTTPServer.BaseHTTPRequestHandler, object):
        def __init__(self, Socket, Address):
            try:
                super(HTTPRequestHandler, self).__init__(Socket, Address, None)
            except Exception as e:
                system.Log("Exception while initializing handler: %s" % e)

        def do_GET(self):
            GetHandler(self)

        def do_POST(self):
            PostHandler(self)

        def log_message(self, Fmt, *Args):
            HttpLogger(Fmt, *Args)

    if HttpLogger is None:
        HttpLogger = lambda *x: None
    NetServer(HTTPRequestHandler, IP, Port, MaxConcurrentConnections, Threaded, Name)
