#!/bin/sh


check_conductor_group()
{
	local _group=$1

	if [ -z "$HOSTNAME" ] ; then
		HOSTNAME="$(/bin/hostname)"
	fi
	if [ -z "$GROUPSLIST" ] ; then
		GROUPSLIST="$(/usr/bin/curl -s https://c.yandex-team.ru/api/hosts2groups/$HOSTNAME)"
	fi

	return $(awk -vG="$_group" 'BEGIN {for (i=1;i<ARGC;++i) if (ARGV[i] == G) {print 0; exit}; print 1}' $GROUPSLIST)
}


write_conductor_hosts()
{
	local _group=$1 _file=$2

	/usr/bin/curl -s https://c.yandex-team.ru/api/groups2hosts/$_group | sort > ${_file}.tmp
	/bin/mv ${_file}.tmp $_file
}


install()
{
	GROUP_DIR="/etc/yandex"
	GROUP_FILE="$GROUP_DIR/group"
	GROUP_HOSTS_FILE="$GROUP_DIR/group_hosts"

	GLIST="
		solomon_pre_storage
		cloud_preprod_solomon-gateway
		cloud_preprod_solomon-stockpile
		solomon_prod_kfront
		solomon_prod_storage_vla
		solomon_prod_storage_sas
		cloud_prod_solomon-gateway
		cloud_prod_solomon-stockpile_vla
		cloud_prod_solomon-stockpile_sas
	"

	echo "Checking for server type ..."
	echo "" > $GROUP_FILE
	echo "" > $GROUP_HOSTS_FILE
	for G in $GLIST ; do
		if check_conductor_group $G ; then
			echo "Server type is '$G'"
			echo "$G" > ${GROUP_FILE}.tmp
			/bin/mv ${GROUP_FILE}.tmp $GROUP_FILE
			echo "Writing group hosts file"
			write_conductor_hosts $G $GROUP_HOSTS_FILE
			break
		fi
	done
}


install
