#!/usr/bin/awk -f

BEGIN {

#--------------------------------------------------------------------------
#
# Get info about present MD arrays and HDDs
#

	cmd = "parted -l"
	while ((cmd | getline) > 0)
		if ($1 == "Disk")
		{
			sub(/:$/, "", $2)


			if ($2 ~ /sd.$/)
			{
				HDD[++h] = $2
				HDDSIZE[h] = $3
			}
			else if ($2 ~ /md.$/)
			{
				MD[++m] = $2
				MDSIZE[m] = $3

				sub(/^.+\//, "", $2)
				MDR[$2] = m
			}
		}
	close(cmd)


#--------------------------------------------------------------------------
#
# Stat for MD
#

	while ((getline < "/proc/mdstat") > 0)
	{
		if ($1 in MDR)
		{
			f = MDR[$1]
			gsub(/^.+:/, "")
		}
		else if (/^[ \t]*$/)
			f = 0

		if (f)
		{
			sub(/^[ \t]+/, "")
			MDP[f] = MDP[f] "\n" $0
		}
	}
	close("/proc/mdstat")



#--------------------------------------------------------------------------
#
# Check if HDDs are of the same sizes
#

	for (i = 1; i <= h; i++)
		for (j = i + 1; j <= h; j++)
			if (HDDSIZE[i] != HDDSIZE[j])
				print "ACHTUNG: Disk " HDD[i] " " HDDSIZE[i] " != " HDD[j] " " HDDSIZE[j]


#--------------------------------------------------------------------------
#
# Remove faulty drives from array
#
	for (i = 1; i <= m; i++)
	{
		cmd = "mdadm " MD[i] " --remove faulty"
		while ((cmd | getline) > 0)
			print "Faulty drive removed from " MD[i] ": " $0
		close(cmd)
	}


#--------------------------------------------------------------------------
#
# Print out which disks are absent from MD arrays
#

	for (i = 1; i <= m; i++)
	{
		r = ""

		cmd = "mdadm --query --detail " MD[i]
		while ((cmd | getline) > 0)
		{
			if (/Used Dev Size/)
				print "\n" MD[i] " (" $8 "/" MDSIZE[i] ") " substr(MDP[i], 2)

			if ($1 == "Number")
				k = index($0, "State")

			if ($1 ~ /^[0-9]+$/)
			{
				r = r sprintf("\n  %2d  %2d:%-2d  %2d  %s", $1, $2, $3, $4,  substr($0, k))
				if ($NF != "removed")
				{
					p = $NF; gsub(/[0-9]+$/, "", p)
					s = $NF; gsub(/^[^0-9]+/, "", s)
					HDP[p]
				}
			}
		}
		close(cmd)

		for (j = 1; j <= h; j++)
			if (!(HDD[j] in HDP))
			{
				sub(/removed/, "REMOVED (" HDD[j] s ")", r)
				badHDD[HDD[j]]
				SR[i, HDD[j]] = s
			}
		delete HDP

		print substr(r, 2)
	}


#--------------------------------------------------------------------------
#
# Print out disk partitioning info
#

	for (i in badHDD)
	{
		print "\nBAD HDD:"
		cmd = "sgdisk -p " i
		while ((cmd | getline) > 0)
			if ($1 ~ /^(Disk|Number|[0-9])$/)
				print
		close(cmd)
	}


	for (i = 1; i <= h; i++)
		if (!(HDD[i] in badHDD))
		{
			gh = i
			break
		}


	print "\nGOOD HDD:"
	cmd = "sgdisk -p " HDD[gh]
	while ((cmd | getline) > 0)
		if ($1 ~ /^(Disk|Number|[0-9]+)$/)
			print
	close(cmd)
	print ""



#--------------------------------------------------------------------------
#
# SMART info
#

	f = 0
	for (i in badHDD)
	{
		cmd = "smartctl -HA " i
		while ((cmd | getline) > 0)
		{
			if ($1 == "===")
				f = 1
			if (f)
				print
		}
		close(cmd)
	}


#--------------------------------------------------------------------------
#
# Propose action
#
	print "\nProposed actions:"


	for (i in badHDD)
	{
		print "sgdisk -R=" i " " HDD[gh]
		print "sgdisk -eG " i
		print "grub-install " i
	}


	for (i = 1; i <= m; i++)
		for (j in badHDD)
			print "mdadm --manage " MD[i] " --add " j SR[i, j]
}
