#!/bin/sh


RC="/etc/resolv.conf"
NS="2a02:6b8:0:3400::1"


update_ip() {
	local _hip=$1

	chattr -i $RC
	awk -vHIP="$_hip" '!/nameserver /
		END {
			print	"nameserver " HIP "\n" \
				"nameserver 2a02:6b8:0:3400::1\n" \
				"nameserver 2a02:6b8::1:1"
		}' $RC > ${RC}.bak
	mv ${RC}.bak $RC
	chattr +i $RC
}


if ! which portoctl >/dev/null 2>&1 ; then
	echo "Cannot fix resolv.conf: no portoctl"
	exit 1
fi
MY_HOST=$(portoctl get self CONTAINER.host 2>/dev/null | awk '{print $1; exit}')
if [ -z "$MY_HOST" ] ; then
	echo "My host is empty"
	exit 1
fi
MY_HOST_IP=$(dig @$NS $MY_HOST AAAA +short 2>/dev/null | awk '{print $1; exit}')
if [ -z "$MY_HOST_IP" ] ; then
	echo "My host IP is empty"
	exit 1
fi
MY_HOST_FROM_IP=$(dig @$NS -x $MY_HOST_IP +short 2>/dev/null | awk '{sub(/\.$/, "", $1); print $1; exit}')
if [ "$MY_HOST" != "$MY_HOST_FROM_IP" ] ; then
	echo "My hostname is not hostname from IP: '$MY_HOST' != '$MY_HOST_FROM_IP'"
	exit 1
fi
CURRENT_IP=$(awk '/nameserver/ {print $2; exit}' $RC 2>/dev/null)
if [ "$CURRENT_IP" = "$MY_HOST_IP" ] ; then
	echo "My host IP is already the first nameserver"
	exit 0
fi
update_ip $MY_HOST_IP
