#!/bin/bash -e

JAVA_OPTS='
    -XX:+UseParallelGC -XX:+UseGCOverheadLimit -XX:GCTimeLimit=95 -XX:GCHeapFreeLimit=20
    -Xlog:gc*:file=/logs/coremon-gc.log:time:filecount=2,filesize=50M -Xlog:gc+ergo
    -Xlog:safepoint:file=/logs/coremon-safepoints.log::filecount=2,filesize=50M
    -XX:-OmitStackTraceInFastThrow
    -XX:+PreserveFramePointer
    --enable-preview
    -XX:MetaspaceSize=256M
    -Dfile.encoding=UTF-8
    -Djava.io.tmpdir=/var/tmp
    -Djava.net.preferIPv6Addresses=true
    -Dru.yandex.solomon.LabelValidator=skip
'

ENV=$(< /etc/solomon/env)
case $ENV in
  production)
    JAVA_OPTS="$JAVA_OPTS -Xmx60g -Xms60g -XX:MaxDirectMemorySize=20G"
    ;;
  prestable)
    JAVA_OPTS="$JAVA_OPTS -Xmx30g -Xms30g -XX:MaxDirectMemorySize=10G"
    ;;
  testing)
    JAVA_OPTS="$JAVA_OPTS -Xmx30g -Xms30g -XX:MaxDirectMemorySize=10G"
    ;;
  cloud-prod)
    JAVA_OPTS="$JAVA_OPTS -Xmx30g -Xms30g -XX:MaxDirectMemorySize=10G"
    ;;
  cloud-preprod)
    JAVA_OPTS="$JAVA_OPTS -Xmx16g -Xms16g -XX:MaxDirectMemorySize=5G"
    ;;
  *)
    echo "Cannot determine environment: $ENV"
    exit 1
    ;;
esac

case $ENV in
  prestable|testing)
    JAVA_OPTS="$JAVA_OPTS --illegal-access=debug -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:7007"
    ;;
esac

export JAVA_OPTS="$JAVA_OPTS"

