#!/bin/sh

# Admin:
# MYT https://yav.yandex-team.ru/secret/sec-01f241hbsg86m6j3s4xtkhw94t/explore/versions
# SAS https://yav.yandex-team.ru/secret/sec-01f240jdv2gd3aryax8g72e8sk/explore/versions
# VLA https://yav.yandex-team.ru/secret/sec-01f23vagd745sy13y6desac2rm/explore/versions
# MAN https://yav.yandex-team.ru/secret/sec-01f3t6yqprxr95a9jcqb0vdrt4/explore/versions
#
# Discovery kubeconfigs: https://yav.yandex-team.ru/secret/sec-01fs70cf3b2abpbfgxg228tvpr

BOOTSTRAP_CONF="discovery_bootstrap.yaml"
CLUSTERS="myt man sas vla"


_make_boostrap() {
	cat > $BOOTSTRAP_CONF <<EOF
apiVersion: v1
kind: ServiceAccount
metadata:
  name: solomon-discovery
  namespace: kube-system
---
apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRole
metadata:
  labels:
    kubernetes.io/bootstrapping: rbac-defaults
  name: system:solomon-discovery
rules:
  - apiGroups: [ "" ]
    resources: [ "endpoints", "services", "pods", "namespaces" ]
    verbs: [ "get", "list", "watch" ]
  - apiGroups: [ "discovery.k8s.io" ]
    resources: [ "endpointslices" ]
    verbs: [ "get", "list", "watch" ]
---
apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRoleBinding
metadata:
  annotations:
    rbac.authorization.kubernetes.io/autoupdate: "true"
  labels:
    kubernetes.io/bootstrapping: rbac-defaults
  name: system:solomon-discovery
roleRef:
  apiGroup: rbac.authorization.k8s.io
  kind: ClusterRole
  name: system:solomon-discovery
subjects:
- kind: ServiceAccount
  name: solomon-discovery
  namespace: kube-system
EOF
}

_make_kube() {
	local _conf=$1 _id=$2 _ep

	_ep="$(awk 'sub(/^\s+server: /, "")' $_conf)"
	TOKENNAME="$(kubectl --kubeconfig $_conf -n kube-system get serviceaccount/solomon-discovery -o jsonpath='{.secrets[0].name}')"
	TOKEN="$(kubectl --kubeconfig $_conf -n kube-system get secret $TOKENNAME -o jsonpath='{.data.token}' | base64 -d)"
	CA="$(kubectl --kubeconfig $_conf -n kube-system get configmap kube-root-ca.crt -o jsonpath='{.data.ca\.crt}' | base64 -w 0)"
	CLUSTER_ID="$_id"
	ENDPOINT="$_ep"

	cat <<EOF
apiVersion: v1
clusters:
- cluster:
    certificate-authority-data: $CA
    server: $ENDPOINT
  name: $CLUSTER_ID
contexts:
- context:
    cluster: $CLUSTER_ID
    user: solomon-discovery
  name: solomon-discovery@$CLUSTER_ID
current-context: solomon-discovery@$CLUSTER_ID
kind: Config
preferences: {}
users:
- name: solomon-discovery
  user:
    token: $TOKEN
EOF
}

_make_boostrap
for CLUSTER in $CLUSTERS ; do
	echo
	echo $CLUSTER
	kubectl --kubeconfig ~/.kube/config_hw_${CLUSTER} apply -f $BOOTSTRAP_CONF
	sleep 5
	_make_kube ~/.kube/config_hw_${CLUSTER} $CLUSTER
done
