#!/bin/bash -e

JAVA_OPTS='
    -XX:+UseParallelGC -XX:+UseGCOverheadLimit -XX:GCTimeLimit=95 -XX:GCHeapFreeLimit=20
    -Xlog:gc*:file=/logs/dumper-gc.log:time:filecount=2,filesize=50M -Xlog:gc+ergo
    -Xlog:safepoint:file=/logs/dumper-safepoints.log::filecount=2,filesize=50M
    -XX:-OmitStackTraceInFastThrow
    -XX:+PreserveFramePointer
    --enable-preview
    -XX:MetaspaceSize=256M
    -Dfile.encoding=UTF-8
    -Djava.io.tmpdir=/var/tmp
    -Djava.net.preferIPv6Addresses=true
    -Dru.yandex.solomon.LabelValidator=skip
'

ENV=$(< /etc/solomon/env)
case $ENV in
  production)
    JAVA_OPTS="$JAVA_OPTS -Xmx10g -Xms10g -XX:MaxDirectMemorySize=10G"
    JAVA_OPTS="$JAVA_OPTS -Dio.netty.leakDetection.level=SIMPLE"
    ;;
  prestable)
    JAVA_OPTS="$JAVA_OPTS -Xmx20g -Xms20g -XX:MaxDirectMemorySize=30G"
    JAVA_OPTS="$JAVA_OPTS -Dio.netty.leakDetection.level=SIMPLE"
    ;;
  testing)
    JAVA_OPTS="$JAVA_OPTS -Xmx10g -Xms10g -XX:MaxDirectMemorySize=10G"
    JAVA_OPTS="$JAVA_OPTS -Dio.netty.leakDetection.level=ADVANCED"
    ;;
  cloud-prod|cloud-preprod)
    JAVA_OPTS="$JAVA_OPTS -Xmx10g -Xms10g -XX:MaxDirectMemorySize=5G"
    JAVA_OPTS="$JAVA_OPTS -Dio.netty.leakDetection.level=DISABLED"
    ;;
  *)
    echo "Cannot determine environment: $ENV"
    exit 1
    ;;
esac

case $ENV in
  prestable)
    JAVA_OPTS="$JAVA_OPTS --illegal-access=debug -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:7007"
    ;;
  testing)
    JAVA_OPTS="$JAVA_OPTS --illegal-access=debug -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:7008"
    ;;
esac

export JAVA_OPTS="$JAVA_OPTS"

