#!/usr/bin/env python3

import time
import datetime
import random
import subprocess
import socket
import argparse


SecretFile = "/Berkanavt/keys/grafana/grafana.secrets"
SSLCAFile = "/etc/grafana/root.crt"
MysqlPassword = ""


# =============================================================================================================


def Log(s):
    TimeStr = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S.%f")
    print("{} - {}".format(TimeStr, s))


def GetFileData(FileName):
    Data = ""
    try:
        File = open(FileName, 'r')
        Data = File.read()
        File.close()
    except (IOError, OSError) as e:
        if e.errno == 2 or e.errno == 3:
            pass
        else:
            raise
    return Data


def Random(Number):
    return Number*random.random()


class Exec:
    def __init__(self, Command):
        try:
            P = subprocess.Popen(Command, env={"LANG": "C"}, stdout=subprocess.PIPE, stderr=subprocess.PIPE, close_fds=True)
            self.out = P.stdout.read().strip().decode("utf-8")
            self.err = P.stderr.read().strip().decode("utf-8")
            P.wait()
            self.status = P.returncode
        except OSError as e:
            Log("Got exception running {}: {}".format(Command, e))
            raise


# =============================================================================================================


def TestIfMyCleanupDay():
    GroupHostsFile = "/etc/solomon/group_hosts"
    GroupHosts = [H.strip() for H in GetFileData(GroupHostsFile).split("\n") if len(H) > 0]
    if len(GroupHosts) == 0:
        Log("Bad group hosts file: no entries")
        exit(1)
    # Day number of the year
    Host = GroupHosts[int(time.strftime("%j")) % len(GroupHosts)]
    MyHostname = socket.gethostname()
    if Host == MyHostname:
        Log("It is my ({}) time to clean up annotations.".format(MyHostname))
    else:
        Log("It is time for {} to clean up annotations, not {}.".format(Host, MyHostname))
        exit(0)


def MysqlCall(Cmd):
    global MysqlPassword

    if len(MysqlPassword) == 0:
        for L in GetFileData(SecretFile).split("\n"):
            LineList = [F.strip() for F in L.split(":")]
            if LineList[0] == "grafana":
                MysqlPassword = LineList[1]
                break
        if len(MysqlPassword) == 0:
            Log("Failed to get MySQL password from {}".format(SecretFile))
            exit(1)

    Cmd = [
        "/usr/bin/mysql",
        "--host=::1",
        "--port=3305",
        "--ssl-ca={}".format(SSLCAFile),
        "--ssl-mode=REQUIRED",
        "--user=grafana",
        "--password={}".format(MysqlPassword),
        "grafana",
        "-e", Cmd
    ]
    return Exec(Cmd)


# =============================================================================================================


def main():
    Parser = argparse.ArgumentParser()
    Parser.add_argument("--random-sleep", type=int, default=0, metavar="MIN", help="minutes to sleep before running (default=%(default)d)")
    Args = Parser.parse_args()

    TestIfMyCleanupDay()

    ChunkSize = 1000
    Days = 90
    Date = int(1000*(time.time() - 86400*Days))

    Sleep = Random(Args.random_sleep)*60
    Log("Random sleep (sleep time={:.2f} sec)".format(Sleep))
    time.sleep(Sleep)

    Rows = int(MysqlCall("select count(*) from annotation where user_id = 0 and epoch < {}".format(Date)).out.split()[-1])
    Log("Rows to delete: {:d}".format(Rows))
    while Rows > 0:
        R = MysqlCall("delete from annotation where user_id = 0 and epoch < {} limit {:d}".format(Date, ChunkSize))
        if R.status != 0:
            Log("Removing {:d} rows failed ({}): {}, {}".format(ChunkSize, R.status, R.out, R.err))
            exit(1)
        Rows -= ChunkSize
        Log("Rows left: {:d}".format(Rows))
        time.sleep(1)


# =============================================================================================================


if __name__ == "__main__":
    main()
