#!/usr/bin/env python3

import time
import datetime
import random
import subprocess
import argparse


SecretFile = "/Berkanavt/keys/grafana/grafana.secrets"
SSLCAFile  = "/etc/grafana/root.crt"
MysqlPassword = ""
MAXTIME = 180


# =============================================================================================================


def Log(s):
    TimeStr = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S.%f")
    print("{} - {}".format(TimeStr, s))


def GetFileData(FileName):
    Data = ""
    try:
        File = open(FileName, 'r')
        Data = File.read()
        File.close()
    except (IOError, OSError) as e:
        if e.errno == 2 or e.errno == 3:
            pass
        else:
            raise
    return Data


def Random(Number):
    return Number*random.random()


class Exec:
    def __init__(self, Command):
        try:
            P = subprocess.Popen(Command, env={"LANG": "C"}, stdout=subprocess.PIPE, stderr=subprocess.PIPE, close_fds=True)
            self.out = P.stdout.read().strip().decode("utf-8")
            self.err = P.stderr.read().strip().decode("utf-8")
            P.wait()
            self.status = P.returncode
        except OSError as e:
            Log("Got exception running {}: {}".format(Command, e))
            raise


# =============================================================================================================


def MysqlCall(Cmd):
    global MysqlPassword

    if len(MysqlPassword) == 0:
        for L in GetFileData(SecretFile).split("\n"):
            LineList = [F.strip() for F in L.split(":")]
            if LineList[0] == "grafana":
                MysqlPassword = LineList[1]
                break
        if len(MysqlPassword) == 0:
            Log("Failed to get MySQL password from {}".format(SecretFile))
            exit(1)

    Cmd = [
        "/usr/bin/mysql",
        "--host=::1",
        "--port=3305",
        "--ssl-ca={}".format(SSLCAFile),
        "--ssl-mode=REQUIRED",
        "--user=grafana",
        "--password={}".format(MysqlPassword),
        "grafana",
        "-e", Cmd
    ]
    return Exec(Cmd)


# =============================================================================================================


def main():
    Parser = argparse.ArgumentParser()
    Parser.add_argument("--random-sleep", type=int, default=0, metavar="MIN", help="minutes to sleep before running (default=%(default)d)")
    Args = Parser.parse_args()

    Sleep = Random(Args.random_sleep)*60
    Log("Random sleep (sleep time={:.2f} sec)".format(Sleep))
    time.sleep(Sleep)

    for L in MysqlCall("show processlist").out.split("\n"):
        LineList = L.split()
        if LineList[1] == "grafana":
            try:
                Time = int(LineList[5])
            except Exception:
                continue
            if Time > MAXTIME:
                Log("Too long request from {} (time={}, id={}): {}".format(LineList[2], Time, LineList[0], LineList[8]))
                C = MysqlCall("kill {}".format(LineList[0]))
                if C.status != 0:
                    Log("Kill status ({}) OUT:{} ERR:{}".format(C.status, C.out, C.err))
                    time.sleep(0.8)
                time.sleep(0.2)


if __name__ == "__main__":
    main()
