import re
import urllib2

import system


# ==============================================================================================================


class TURLChecker(object):
    reAllDigits = re.compile("(?:\d+\.?\d*)")

    def __init__(self, Tag=None):
        self.Tag              = Tag
        self.MaxPrintLines    = 5
        self.SearchURLDict    = {}
        self.CounterDict      = {}
        self.CounterDeltaDict = {}

    def Log(self, String):
        if not self.Tag is None:
            system.Log("[%s] %s" % (self.Tag, String))
        else:
            system.Log("%s" % String)

    def AddCheckURL(self, URL, SearchLineDict):
        '''
        AddCheckURL("<PORT>/<PATH>", {"<SEARCH_STRING>":{"position":<POSITION_NUMBER_TO_CHECK>,"OK":"<OK_PREDICATE_WITH_VALUE_OR_DELTA>"}, ...})
        '''
        self.SearchURLDict["http://localhost:%s" % URL] = SearchLineDict

    def SetURLDict(self, URLDict):
        self.SearchURLDict = {"http://localhost:%s" % URL:URLDict[URL] for URL in URLDict}

    def IsReady(self):
        Ready = None
        for URL in self.SearchURLDict:
            URLIsOk        = None
            PrintLinesLeft = self.MaxPrintLines
            SearchLineDict = self.SearchURLDict[URL]
            self.Log("checking '%s' for '%s'" % (URL, SearchLineDict))
            for Line in system.GetURL(URL):
                for SearchLine in SearchLineDict:
                    if Line.find(SearchLine) >= 0:
                        OKCondition = SearchLineDict[SearchLine]["OK"]
                        Position    = SearchLineDict[SearchLine]["position"]
                        try:
                            Counter = int(self.reAllDigits.findall(Line.decode("utf-8"))[Position])
                        except IndexError:
                            self.Log("%s no counter at position %d at '%s'" % (URL, Position, repr(Line)))
                            return None
                        Delta                             = Counter - self.CounterDict.get(SearchLine, 0)
                        self.CounterDict[SearchLine]      = Counter
                        self.CounterDeltaDict[SearchLine] = Delta
                        if not eval(re.sub("DELTA", str(Delta), re.sub("VALUE", str(Counter), OKCondition))):
                            URLIsOk = False
                            self.Log("%s %s, value=%d, delta=%d (%s - VIOLATED)" % (URL, repr(Line), Counter, Delta, OKCondition))
                        elif PrintLinesLeft > 0:
                            self.Log("%s %s, value=%d, delta=%d (%s - OK)"       % (URL, repr(Line), Counter, Delta, OKCondition))
                            if URLIsOk is None:
                                URLIsOk = True
                            PrintLinesLeft -= 1
            if URLIsOk is None:
                self.Log("%s cannot find target lines '%s'" % (URL, repr(SearchLineDict)))
                return None
            if URLIsOk is False:
                Ready = False
            if URLIsOk is True and Ready is None:
                Ready = True
        return Ready
