import gevent
from gevent.server import StreamServer
from gevent.pool import Pool
import BaseHTTPServer


# ==============================================================================================================


MAXCONCURRENTCONNECTIONS = 10


# ==============================================================================================================


def NetServer(RequestHandler, IP="127.0.0.1", Port=8080, MaxConcurrentConnections=MAXCONCURRENTCONNECTIONS):
    Server = StreamServer((IP, Port), RequestHandler, spawn=Pool(MaxConcurrentConnections))
    Server.start()


def HttpServer(GetHandler=None, PostHandler=None, IP="127.0.0.1", Port=8080, MaxConcurrentConnections=MAXCONCURRENTCONNECTIONS):
    class HTTPRequestHandler(BaseHTTPServer.BaseHTTPRequestHandler, object):
        def __init__(self, Socket, Address):
            try:
                super(HTTPRequestHandler, self).__init__(Socket, Address, None)
            except Exception as e:
                system.Log("Exception while initializing handler: %s %s %s" % (e.args, e.message, e.__str__()))

        def do_GET(self):
            if GetHandler is not None:
                GetHandler(self)
            else:
                self.send_response(200)
                self.send_header("Connection", "Close")
                self.end_headers()

        def do_POST(self):
            if PostHandler is not None:
                PostHandler(self)
            else:
                self.send_response(200)
                self.send_header("Connection", "Close")
                self.end_headers()

    NetServer(HTTPRequestHandler, IP, Port, MaxConcurrentConnections)
