import system
import servicechecker
import taskloop
from checks import url


# ==============================================================================================================


class TPool(object):
    DOWN = servicechecker.TServiceChecker.DOWN
    UP   = servicechecker.TServiceChecker.UP

    def __init__(self):
        self.ServiceCheckerDict = {}
        self.TasksDict = {}
        self.TasksLoop = taskloop.TTasksLoop()

    def AddService(self, Service, Process=None, ProcessFilter=None, ReadyFuncList=[], PingFunction=None, TargetState=UP, ReadyWaitTime=300, ResetWaitTime=1800, URLDict={}, Period=15, Timeout=10):
        if len(URLDict) > 0:
            URLCheck = url.TURLChecker(Tag=Service)
            URLCheck.SetURLDict(URLDict)
            ReadyFuncList = [F for F in ReadyFuncList] + [URLCheck.IsReady]
        ServiceChecker = servicechecker.TServiceChecker(Service, Process=Process, ProcessFilter=ProcessFilter, ReadyFuncList=ReadyFuncList, PingFunction=PingFunction, TargetState=TargetState, ReadyWaitTime=ReadyWaitTime, ResetWaitTime=ResetWaitTime)
        if ServiceChecker.Service.StartSystem is not None:
            self.TasksLoop.AddTask(ServiceChecker.Check, Period=Period, Timeout=Timeout, Tag=Service)
        else:
            system.Log("Service '%s' was not found on the system" % Service)
            return
        self.ServiceCheckerDict[Service] = ServiceChecker

    def AddTask(self, Function, Period=15, Timeout=14, Params=(), Tag=None):
        self.TasksLoop.AddTask(Function, Period=Period, Timeout=Timeout, Params=Params, Tag=Tag)
        self.TasksDict[Function.__name__] = None

    def GetService(self, Service):
        ServiceChecker = self.ServiceCheckerDict.get(Service, None)
        return ServiceChecker.Service if not ServiceChecker is None else None

    def GetChecker(self, Service):
        return self.ServiceCheckerDict.get(Service, None)

    def Run(self):
        self.TasksLoop.Run()

    def __dict__(self):
        StrDict = {}
        for Service in self.ServiceCheckerDict:
            ServiceChecker = self.ServiceCheckerDict[Service]
            StrDict[ServiceChecker.Service.Service] = {
                "status":  ServiceChecker.Service.__dict__(),
                "running": ServiceChecker.Running,
                "ready":   ServiceChecker.Ready,
                "reset":   ServiceChecker.ResetCounter,
                "lastrunning":    ServiceChecker.LastRunningTime,
                "lastready":      ServiceChecker.LastReadyTime,
                "lastreset":      ServiceChecker.LastResetTime,
                "badstartsystem": ServiceChecker.StartSystemIsBad
            }
        return StrDict

    def __short__(self):
        BadInit     = reduce(lambda x, y: x or y, [self.ServiceCheckerDict[s].StartSystemIsBad for s in self.ServiceCheckerDict])
        ReadyDict   = {s: self.ServiceCheckerDict[s].Ready        for s in self.ServiceCheckerDict}
        RunningDict = {s: self.ServiceCheckerDict[s].Running      for s in self.ServiceCheckerDict}
        ResetDict   = {s: self.ServiceCheckerDict[s].ResetCounter for s in self.ServiceCheckerDict}
        return {
            "badinit": 1 if BadInit else 0,
            "ready":   ReadyDict,
            "running": RunningDict,
            "reset":   ResetDict
        }
