#!/usr/bin/env python

from __future__ import print_function
import os
import socket
import syslog
import urllib2
import subprocess
import datetime


# ==============================================================================================================


MINSERVERUPTIME = 3600


# ==============================================================================================================


class TimedOut(Exception):
    pass


#__builtins__.orig_print = __builtins__.print
def Log(*args, **kwargs):
    #__builtins__.orig_print("%s - " % datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S.%f"), *args, **kwargs)
    print("%s - " % datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S.%f"), *args, **kwargs)
#__builtins__.print = Log


def SysLog(Ident, s):
    syslog.openlog(ident=Ident, facility=syslog.LOG_LOCAL0)
    syslog.syslog(syslog.LOG_CRIT, s)
    syslog.closelog()


class Exec:
    def __init__(self, command):
        try:
            p = subprocess.Popen(command, env={"LANG": "C"}, stdout=subprocess.PIPE, stderr=subprocess.PIPE, close_fds=True)
            self.out = p.stdout.read().strip()
            self.err = p.stderr.read().strip()
            p.wait()
            self.status = p.returncode
        except OSError as e:
            Log("Got exception running %s: %s" % (command, e))
            raise


def NormalRand(Number):
    N = 0
    for i in os.urandom(8):
        N = (N<<8) + ord(i)
    return N%int(Number)


def KillServerReboot():
    with open("/proc/uptime", "r") as f:
        Uptime = float(f.readline().split()[0])
        if Uptime > MINSERVERUPTIME:
            Log("Rebooting server with %.1f uptime" % Uptime)
            os.system("/sbin/shutdown -r now")
        else:
            Log("Not rebooting: server has only %.1f uptime" % Uptime)


def GetHostname():
    return socket.gethostname()


def GetURL(URL, Headers={}, Data=None, Timeout=4):
    try:
        Req  = urllib2.Request(URL, Data, Headers)
        Sock = urllib2.urlopen(Req, timeout=Timeout)
        for Line in Sock.read().split('\n'):
            yield Line
    except TimedOut:
        raise
    except Exception as e:
        Log("Exception in GetURL for '%s' - %s" % (URL, e.__str__()))


def GetCommandFromPid(Pid):
    try:
        ExePath = os.readlink(os.path.join("/proc", str(Pid), "exe"))
        return ExePath.split('/')[-1]
    except OSError:
        pass
    return None


def GetPidStartTime(Pid):
    try:
        Line = GetFileData(os.path.join("/proc", str(Pid), "stat"))
        if len(Line) > 0:
            return int(Line.split(None, 22)[21])
    except (ValueError, IndexError, KeyError):
        pass
    return None


def PGrep(ProcessName, ProcessFilter=None, Count=False):
    if ProcessFilter is None:
        return Exec(["/usr/bin/pgrep", "-x" + ("c" if Count else "o"), ProcessName.__str__()]).out
    return Exec(["/usr/bin/pgrep", "-f" + ("c" if Count else "o"), "/%s .*%s" % (ProcessName, ProcessFilter)]).out


def GetChildren(Pid, Recursive=False):
    PidList = Exec(["/usr/bin/pgrep", "-P", str(Pid)]).out.split()
    if Recursive:
        SubPidList = []
        for Pid in PidList:
            SubPidList += GetChildren(Pid, Recursive=True)
        PidList += SubPidList
    return PidList


def PID(Pid):
    try:
        Pid = int(Pid)
        return None if Pid == 0 else Pid
    except ValueError:
        return None


def PIDUptime(Pid=os.getpid()):
    for Line in GetFileData("/proc/stat", 16384).split('\n'):
        if Line.startswith("btime"):
            BootTime = int(Line.split()[1])
    Tick = os.sysconf(os.sysconf_names["SC_CLK_TCK"])
    StartTime = int(GetFileData("/proc/%d/stat" % Pid).split()[21])/Tick
    return BootTime + StartTime


def GetFileData(FileName, MaxSize=4096):
    try:
        File = os.open(FileName, os.O_RDONLY)
        Data = os.read(File, MaxSize).decode("utf-8")
        os.close(File)
        if len(Data) > 0:
            return Data
    except OSError as e:
        if e.errno == 2 or e.errno == 3:
            pass
        else:
            raise
    return ""
