import gevent
import time

import system


# ==============================================================================================================


class TTasksLoop(object):
    def __init__(self):
        self.TaskList = []

    def AddTask(self, Function, Period=60, Timeout=10, Params=(), Tag=None):
        self.TaskList.append({"function":Function, "period":Period, "timeout":Timeout, "params":Params, "tag":Tag})

    def Task(self, Function, Period, Timeout, Params, Tag):
        TagText = "[%s] " % Tag if Tag is not None else ""
        while True:
            TimeStart = time.time()
            system.Log("%srunning %s%s, period %.3f, timeout %.3f" % (TagText, Function.__name__, Params, Period, Timeout))
            try:
                if Timeout <= 0:
                    Function(*Params)
                else:
                    with gevent.Timeout(Timeout, system.TimedOut):
                        Function(*Params)
                Text = "is done in"
            except system.TimedOut:
                Text = "timed out after"
            except Exception as e:
                Text = "got exception '%s' after" % e.__str__()
            DeltaTime = time.time() - TimeStart
            system.Log("%sfunction %s%s %s %.3f seconds" % (TagText, Function.__name__, Params, Text, DeltaTime))
            if Period <= 0:
                break
            SleepTime = Period - DeltaTime
            if SleepTime > 0:
                gevent.sleep(SleepTime)

    def Run(self):
        try:
            gevent.joinall([gevent.spawn(
                self.Task,
                T["function"],
                T["period"],
                T["timeout"],
                T["params"],
                T["tag"]
            ) for T in self.TaskList])
        except KeyboardInterrupt:
            pass
