#!/usr/bin/env python

import gevent.monkey
gevent.monkey.patch_all()
import json
import time

import system
import netserver
import pool


# ==============================================================================================================


IP = "::"
PORT = 6000
SOLOMON_PORT = 6001


# ==============================================================================================================


def NetRequestHandler(Socket, Address):
    system.Log("[net-interface] recieved from %s:%d" % (Address[0], Address[1]))
    Dict = Pool.__short__()
    Line = "Check!"
    system.Log("[net-interface] reply to %s:%d: %s" % (Address[0], Address[1], Line))
    Socket.sendall(Line + "\n")
    Socket.close()


# ==============================================================================================================


def HttpGetRequestHandler(HTTPRequestHandler):
    Dict = Pool.__dict__()
    Msg = json.dumps({"sensors": [{"labels": {"process": Service, "sensor": "resets"}, "kind": "RATE", "value": Dict[Service]["reset"]} for Service in Dict]})
    system.Log("Reply with solomon json: %s" % Msg)
    HTTPRequestHandler.send_response(200)
    HTTPRequestHandler.send_header("Content-type", "application/json")
    HTTPRequestHandler.send_header("Connection", "Close")
    HTTPRequestHandler.end_headers()
    HTTPRequestHandler.wfile.write(Msg)


# ==============================================================================================================


TorrentCountersDict = {}
TriggerCountersDict = {}
Pool = pool.TPool()

def main():
    netserver.NetServer(NetRequestHandler, IP, PORT)
    netserver.HttpServer(GetHandler=HttpGetRequestHandler, IP=IP, Port=SOLOMON_PORT)

    Pool.AddService("yandex-hbf-agent", "hbf-agent")
    Pool.AddService("rsyslog", "rsyslogd")

    Pool.AddService("mega-graphite-web", "python2.7")
    Pool.AddService("mega-graphite-storage", "java")

    Pool.AddService("nginx", "nginx")

    Pool.Run()


# ==============================================================================================================


if __name__ == "__main__":
    main()
