#!/bin/bash -e

JAVA_OPTS='
    -XX:+UseParallelGC -XX:+UseGCOverheadLimit -XX:GCTimeLimit=95 -XX:GCHeapFreeLimit=20
    -Xlog:gc*:file=/logs/alerting-gc.log:time:filecount=2,filesize=50M -Xlog:gc+ergo
    -Xlog:safepoint:file=/logs/alerting-safepoints.log::filecount=2,filesize=50M
    -XX:-OmitStackTraceInFastThrow
    -XX:+PreserveFramePointer
    --enable-preview
    -XX:MetaspaceSize=256M
    -Dfile.encoding=UTF-8
    -Djava.io.tmpdir=/var/tmp
    -Djava.net.preferIPv6Addresses=true
    -Dru.yandex.solomon.LabelValidator=skip
    -Djava.security.egd=file:/dev/./urandom
'

ENV=$(< /etc/solomon/env)
case $ENV in
  production)
    JAVA_OPTS="$JAVA_OPTS -Xmx40g -Xms40g -XX:MaxDirectMemorySize=15G"
    ;;
  prestable)
    JAVA_OPTS="$JAVA_OPTS -Xmx8g -Xms8g -XX:MaxDirectMemorySize=16G"
    ;;
  testing)
    JAVA_OPTS="$JAVA_OPTS -Xmx8g -Xms8g -XX:MaxDirectMemorySize=16G"
    ;;
  cloud-prod)
    JAVA_OPTS="$JAVA_OPTS -Xmx8g -Xms8g -XX:MaxDirectMemorySize=16G"
    ;;
  cloud-preprod)
    JAVA_OPTS="$JAVA_OPTS -Xmx4g -Xms4g -XX:MaxDirectMemorySize=4G"
    ;;
  israel)
    JAVA_OPTS="$JAVA_OPTS -Xmx4g -Xms4g -XX:MaxDirectMemorySize=4G"
    ;;
  *)
    echo "Cannot determine environment: $ENV"
    exit 1
    ;;
esac

case $ENV in
  prestable|testing)
    JAVA_OPTS="$JAVA_OPTS -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:7007"
    ;;
esac

export JAVA_OPTS="$JAVA_OPTS"

