#!/usr/bin/awk -f
#
# File format:
# dir:/etc/yandex-solomon-agent cloud-prod:agent_prod.conf cloud-preprod:agent_preprod.conf agent.conf
# or
# dir:/etc/yandex-solomon-agent *:agent_${ENV}_${DC}.conf agent.conf
#

BEGIN {
	test = 0

	while (1) {
		getline env < "/etc/solomon/env"
		getline dc < "/etc/solomon/dc"
		if (length(env) == 0 || length(dc) == 0) {
			printf("Bad input: env=%s dc=%s\n", env, dc)
			system("exec /bin/sleep 1")
			continue
		}
		break
	}
	e = sprintf("ENV=%s; env=%s; DC=%s; dc=%s;", env, env, dc, dc)
} {
	gsub(/#.*$/, "")
	delete A
	delete D
	for (i = 1; i < NF; i++) {
		if (split($i, A, /:/) == 2) {
			D[tolower(A[1])] = A[2]
		}
	}

	src = D[(env in D) ? env : "*"]
	if (src == "") {
		next
	}
	dst = $NF

	cmd = ("dir" in D) ? e " test -d " D["dir"] " || exit 1; cd " D["dir"] ";" : e
	cmd = cmd " ln -vsf " src " " dst

	if (test) {
		print(cmd)
	} else {
		system(cmd)
	}
}
