#!/bin/sh

IPTABLES="/sbin/iptables"
IPTABLES_RESTORE="/sbin/iptables-restore"
IP6TABLES="/sbin/ip6tables"
IP6TABLES_RESTORE="/sbin/ip6tables-restore"
#
GPN="2a0d:d6c0::/29"
ISRAEL="2a11:f740::/48 2a11:f740:1::/48 2a11:f740:2::/48" # CLOUD-93131 - Underlay Overlay_Private Overlay_Public
YNETS="2a02:6b8::/32 $ISRAEL"


ipt() {
    local _in=$1 _if_overlay="eth0"

    echo "
    # -A $_in ! -i lo -s 127.0.0.0/8 -j DROP
    -A $_in -i lo -j ACCEPT
    -A $_in -m conntrack --ctstate RELATED,ESTABLISHED -j ACCEPT
    # dhcpv4
    -A $_in -p udp --dport 67:68 --sport 67:68 -j ACCEPT
    -A $_in -p icmp -j ACCEPT
    # nginx
    -A $_in -p tcp -i $_if_overlay -m multiport --dports 80,443,4443,4480 -j ACCEPT
    # healthchecks
    -A $_in -p tcp -i $_if_overlay -m multiport --dports 4500,4510,4530,4540,4580 -j ACCEPT
    "
}

ip6t() {
    local _in6=$1 _if_underlay="eth1" _if_overlay="eth0"

    echo "
    # -A $_in6 ! -i lo -s ::1/128 -j DROP
    -A $_in6 -i lo -j ACCEPT
    -A $_in6 -m conntrack --ctstate RELATED,ESTABLISHED -j ACCEPT
    # dhcpv6
    -A $_in6 -p udp -s fe80::/10 -d fe80::/10 --dport 546 --sport 547 -j ACCEPT
    "

    for N in $YNETS ; do
        echo "
        # dhcpv6
        -A $_in6 -p udp -s $N -d fe80::/10 --dport 546 --sport 547 -j ACCEPT
        # ssh
        -A $_in6 -p tcp -i $_if_underlay -s $N --dport 22 -j ACCEPT
        # solomon-sysmond
        -A $_in6 -p tcp -i $_if_underlay -s $N --dport 3443 -j ACCEPT
        # solomon-agent
        -A $_in6 -p tcp -i $_if_underlay -s $N -m multiport --dports 4591,4592,8080,8081 -j ACCEPT
        # unified-agent
        -A $_in6 -p tcp -i $_if_underlay -s $N --dport 16300 -j ACCEPT
        # backup
        -A $_in6 -p tcp -i $_if_underlay -s $N -m multiport --dports 7002 -j ACCEPT
        # nginx
        -A $_in6 -p tcp -i $_if_underlay -s $N -m multiport --dports 80,443,4443,4480,28019 -j ACCEPT
        -A $_in6 -p tcp -i $_if_overlay  -s $N -m multiport --dports 80,443,4443,4480 -j ACCEPT
        # gateway
        -A $_in6 -p tcp -i $_if_underlay -s $N -m multiport --dports 4540,5540,5740,6740 -j ACCEPT
        # project-manager
        -A $_in6 -p tcp -i $_if_underlay -s $N -m multiport --dports 4580,5580,5780 -j ACCEPT
        # alerting
        -A $_in6 -p tcp -i $_if_underlay -s $N -m multiport --dports 4530,8799,8800 -j ACCEPT
        # coremon
        -A $_in6 -p tcp -i $_if_underlay -s $N -m multiport --dports 4510,4710,5710 -j ACCEPT
        # fetcher
        -A $_in6 -p tcp -i $_if_underlay -s $N -m multiport --dports 4720,4520,4620,4610 -j ACCEPT
        # name resolver
        -A $_in6 -p tcp -i $_if_underlay -s $N -m multiport --dports 4590,5900 -j ACCEPT
        # sockpile
        -A $_in6 -p tcp -i $_if_underlay -s $N -m multiport --dports 4700,5700,4500 -j ACCEPT
        "
    done

    echo "
    -A $_in6 -p ipv6-icmp -j ACCEPT
    "
}

main() {
    local _in="SOLOMON_IN" _in6="SOLOMON_IN" _log_common="-m limit --limit 5/min"

    $IPTABLES -F
    $IPTABLES -X
    $IPTABLES -N $_in
    $IPTABLES -A INPUT -j $_in
    $IPTABLES -A INPUT $_log_common -j LOG
    $IPTABLES -A INPUT -j DROP

    $IPTABLES -A FORWARD $_log_common -j LOG
    $IPTABLES -A FORWARD -j DROP

    $IP6TABLES -F
    $IP6TABLES -X
    $IP6TABLES -N $_in6
    $IP6TABLES -A INPUT -j $_in6
    $IP6TABLES -A INPUT $_log_common -j LOG
    $IP6TABLES -A INPUT -j DROP

    $IP6TABLES -A FORWARD $_log_common -j LOG
    $IP6TABLES -A FORWARD -j DROP

    ( echo "*filter"
    ipt $_in
    echo "COMMIT" ) | awk '(gsub(/^[[:space:]]*|[[:space:]]*(#.*)?$/, "") || 1) && length()' | $IPTABLES_RESTORE -nv -T filter

    ( echo "*filter"
    ip6t $_in6
    echo "COMMIT" ) | awk '(gsub(/^[[:space:]]*|[[:space:]]*(#.*)?$/, "") || 1) && length()' | $IP6TABLES_RESTORE -nv -T filter
}


main "$1"
