#!/usr/bin/python3

import sys
import json
import ipaddress
import netifaces


dc_file = "/etc/solomon/dc"


def read_file(name):
    try:
        with open(name, "r") as file:
            return file.read()
    except Exception:
        return "{}"


def write_file(name, content, mode='w'):
    with open(name, mode) as file:
        file.write(content)


def main():
    dc_dict_string = read_file(sys.argv[1]).strip().replace("'", "\"")
    print("Got DC data: {}".format(dc_dict_string))

    dc_dict = json.loads(dc_dict_string)
    print("Loaded DC dict: {}".format(dc_dict))

    ip = ipaddress.ip_address(netifaces.ifaddresses("eth0")[netifaces.AF_INET][0]["addr"])
    print("Got my IP: {}".format(ip))

    my_dcs = [dc for dc, net in dc_dict.items() if ip in ipaddress.ip_network(net)]
    print("Got my DCs: {}".format(my_dcs))

    write_file(dc_file, my_dcs[0] if len(my_dcs) == 1 else "unknown-dc")


if __name__ == "__main__":
    main()
