#!/bin/bash -e

JAVA_OPTS='
    -XX:+UseParallelGC -XX:+UseGCOverheadLimit -XX:GCTimeLimit=95 -XX:GCHeapFreeLimit=20
    -Xlog:gc*:file=/logs/name-resolver-gc.log:time:filecount=2,filesize=50M -Xlog:gc+ergo
    -Xlog:safepoint:file=/logs/name-resolver-safepoints.log::filecount=2,filesize=50M
    -XX:-OmitStackTraceInFastThrow
    -XX:+PreserveFramePointer
    --enable-preview
    -XX:MetaspaceSize=256M
    -Dfile.encoding=UTF-8
    -Djava.io.tmpdir=/var/tmp
    -Djava.net.preferIPv6Addresses=true
    -Dru.yandex.solomon.LabelValidator=skip
'

ENV=$(< /etc/solomon/env)
case $ENV in
  cloud-preprod)
    JAVA_OPTS="$JAVA_OPTS -Xmx2g -Xms1g -XX:MaxDirectMemorySize=1G"
    JAVA_OPTS="$JAVA_OPTS -Dio.netty.leakDetection.level=SIMPLE"
    ;;
  cloud-prod)
    JAVA_OPTS="$JAVA_OPTS -Xmx4g -Xms2g -XX:MaxDirectMemorySize=2G"
    JAVA_OPTS="$JAVA_OPTS -Dio.netty.leakDetection.level=DISABLED"
    ;;
  israel)
    JAVA_OPTS="$JAVA_OPTS -Xmx2g -Xms1g -XX:MaxDirectMemorySize=1G"
    JAVA_OPTS="$JAVA_OPTS -Dio.netty.leakDetection.level=SIMPLE"
    ;;
  *)
    echo "Cannot determine environment: $ENV"
    exit 1
    ;;
esac

export JAVA_OPTS="$JAVA_OPTS"
