#!/bin/bash -e

JAVA_OPTS='
    -XX:+UseParallelGC -XX:+UseGCOverheadLimit -XX:GCTimeLimit=95 -XX:GCHeapFreeLimit=20
    -Xlog:gc*:file=/logs/stockpile-gc.log:time:filecount=2,filesize=50M -Xlog:gc+ergo
    -Xlog:safepoint:file=/logs/stockpile-safepoints.log::filecount=2,filesize=50M
    -XX:-OmitStackTraceInFastThrow
    -XX:+PreserveFramePointer
    --enable-preview
    -XX:MetaspaceSize=256M
    -Dfile.encoding=UTF-8
    -Djava.io.tmpdir=/var/tmp
    -Djava.net.preferIPv6Addresses=true
    -Dru.yandex.solomon.LabelValidator=skip
    -Dio.netty.leakDetection.level=SIMPLE
'

ENV=$(< /etc/solomon/env)
case $ENV in
  production)
    JAVA_OPTS="$JAVA_OPTS -Xmx80g -Xms80g -XX:MaxDirectMemorySize=20G"
    ;;
  prestable)
    JAVA_OPTS="$JAVA_OPTS -Xmx80g -Xms80g -XX:MaxDirectMemorySize=10G"
    ;;
  testing)
    JAVA_OPTS="$JAVA_OPTS -Xmx50g -Xms50g -XX:MaxDirectMemorySize=5G"
    ;;
  cloud-prod|cloud-preprod)
    JAVA_OPTS="$JAVA_OPTS -Xmx30g -Xms30g -XX:MaxDirectMemorySize=5G"
    ;;
  israel)
    JAVA_OPTS="$JAVA_OPTS -Xmx40g -Xms40g -XX:MaxDirectMemorySize=10G"
    ;;
  *)
    echo "Cannot determine environment: $ENV"
    exit 1
    ;;
esac

export JAVA_OPTS="$JAVA_OPTS"

