#!/bin/sh

CONF="/etc/containerd/config.toml"
IMAGE="$(awk 'sub(/^\s+sandbox_image\s+=\s+/, "") {gsub(/"/, "", $1); print $1}' $CONF 2>/dev/null)"
REPO="$(echo $IMAGE | sed 's/\/.*$//')"
AUTH="$(python -c 'import json; print(json.load(open("/var/lib/kubelet/config.json")).get("auths", {}).get("'${REPO}'", {}).get("auth", ""))' 2>/dev/null)"

if [ -n "$IMAGE" -a -n "$AUTH" ] ; then
	echo "Pulling pause image $IMAGE"
	crictl --runtime-endpoint unix:///run/containerd/containerd.sock pull --auth $AUTH $IMAGE
else
	echo "Failed to pull pause image $IMAGE"
fi
