#!/bin/sh


set -e


#-------------------------------------------------------------------------


_p() {
	local _pause
	echo
	echo $1
	echo -n "Press ctrl+c to break..."
	read _pause
}

install_conf() {
	echo "Installing configuration file: $1"
	[ -s "$1" -a ! -f "$1.BACKUP" ] && cp -f "$1" "$1.BACKUP"
	[ -f "$1.yandex" ] && cp -f "$1.yandex" "$1"
}

deinstall_conf() {
	echo "Deinstalling configuration file: $1"
	[ -s "$1" -a -f "$1.BACKUP" ] && cp -f "$1.BACKUP" "$1"
	rm -f "$1.BACKUP"
}

check_mod() {
	mod=$1 ; shift
	own=$1 ; shift

	echo "Checking file or directory $@ for mod $mod and owner $own"
	if [ -d "$@" -o -f "$@" ] ; then
		chmod $mod "$@"
		chown $own "$@"
	fi
}

_rand() {
	local _n=$1

	head -c $((2*$_n)) /dev/urandom | base64 | sed 's/[^A-Za-z0-9]//g' | head -c $_n
}


#-------------------------------------------------------------------------


_install() {
	INSTALLDBLOG="/Berkanavt/mysql/logs/setup.log"
	NEWDBDIR="/Berkanavt/mysql/db"
	MYCNF="/etc/mysql/my.cnf"
	MYROOTCNF="/root/.my.cnf"
	DEBCNF="/etc/mysql/debian.cnf"
	TEMP_INIT="/Berkanavt/mysql/tmp/init.cnf"

	PASS_DEB="$(_rand 15)"
	PASS_ROOT="$(_rand 15)"

	echo "Ready to update $MYCNF"
	install_conf $MYCNF
	check_mod 440 mysql:root $MYCNF

	echo "# mysql config file
[mysql]
user = root
password = '${PASS_ROOT}'
socket = /var/run/mysqld/mysqld.sock
" > $MYROOTCNF
	check_mod 400 root:root $MYROOTCNF

	_p "Ready to update $DEBCNF"
	install_conf $DEBCNF
	sed -i "s/SECRETPASSWORD/${PASS_DEB}/" $DEBCNF
	check_mod 600 root:root $DEBCNF

	echo "USE mysql;
ALTER USER 'root'@'localhost' IDENTIFIED BY '$PASS_ROOT';
CREATE USER IF NOT EXISTS 'debian-sys-maint'@'localhost' IDENTIFIED BY '$PASS_DEB';
GRANT ALL ON *.* TO 'debian-sys-maint'@'localhost' WITH GRANT OPTION;
SHUTDOWN;" > $TEMP_INIT
	check_mod 600 mysql:mysql $TEMP_INIT

	# reconfigure mysql server
	_p "Ready to PURGE MySQL server"
	echo "Stopping mysql server..."
	systemctl stop mysql

	rm -vfr /var/lib/mysql/* ${NEWDBDIR}/*
	echo "Install mysql db anew..."
	cd ${NEWDBDIR}
	mysqld --log-error-verbosity=3 --initialize-insecure --init-file=$TEMP_INIT --user=mysql > $INSTALLDBLOG 2>&1 #|| true
	rm $TEMP_INIT

	killall -15 mysqld 2>/dev/null || true; sleep 2
	killall -9 mysqld 2>/dev/null || true; sleep 1
	echo "Start mysql server..."
	systemctl start mysql
}


#-------------------------------------------------------------------------


_install
