#!/usr/bin/env python3

import time
import datetime
import random
import subprocess


SecretFile = "/Berkanavt/keys/grafana/grafana.secrets"
SSLCAFile  = "/etc/grafana/root.crt"
MysqlPassword = ""


# =============================================================================================================


def Log(s):
    TimeStr = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S.%f")
    print("{} - {}".format(TimeStr, s))


def GetFileData(FileName):
    Data = ""
    try:
        File = open(FileName, 'r')
        Data = File.read()
        File.close()
    except (IOError, OSError) as e:
        if e.errno == 2 or e.errno == 3:
            pass
        else:
            raise
    return Data


def Random(Number):
    return Number*random.random()


class Exec:
    def __init__(self, Command):
        try:
            P = subprocess.Popen(Command, env={"LANG": "C"}, stdout=subprocess.PIPE, stderr=subprocess.PIPE, close_fds=True)
            self.out = P.stdout.read().strip().decode("utf-8")
            self.err = P.stderr.read().strip().decode("utf-8")
            P.wait()
            self.status = P.returncode
        except OSError as e:
            Log("Got exception running {}: {}".format(Command, e))
            raise


# =============================================================================================================


def MysqlCall(Cmd):
    global MysqlPassword

    if len(MysqlPassword) == 0:
        for L in GetFileData(SecretFile).split("\n"):
            LineList = [F.strip() for F in L.split(":")]
            if LineList[0] == "grafana":
                MysqlPassword = LineList[1]
                break
        if len(MysqlPassword) == 0:
            Log("Failed to get MySQL password from {}".format(SecretFile))
            exit(1)

    Cmd = [
        "/usr/bin/mysql",
        "--host=::1",
        "--port=3305",
        "--ssl-ca={}".format(SSLCAFile),
        "--ssl-mode=REQUIRED",
        "--user=grafana",
        "--password={}".format(MysqlPassword),
        "grafana",
        "-e", Cmd
    ]
    return Exec(Cmd)


# =============================================================================================================
InputFile = "test_input.txt"


def main():
    ButchSize = 1
    LL = [L for L in GetFileData(InputFile).split("\n") if len(L) > 0]
    N = 0
    while len(LL) > 0:
        BL = LL[:ButchSize]
        LL = LL[ButchSize:]
        Log("#{}  {}".format(N, " ".join(BL)))
        Where = "slug = '{}'".format("' or slug = '".join(BL))
        Cmd = "SELECT t1.slug,t1.title,t1.updated,t2.login FROM dashboard as t1, user as t2 WHERE ( {} ) and t2.id = t1.updated_by".format(Where)
        C = MysqlCall(Cmd)
        if C.status != 0:
            Log("MySQL call status ({}) OUT:{} ERR:{}".format(C.status, C.out, C.err))
            break
        print(Cmd.out)

        time.sleep(0.2)
        N += 1
        if N >= 1:
            break


if __name__ == "__main__":
    main()
