package main

import (
	"bufio"
	"fmt"
	"log"
	"os"
	"regexp"
	"strconv"
	"strings"
)

type filterFunc func(*string) bool

var (
	tableName    = "annotation"
	tableNameNew = "annotation_tmp"

	rowFilterLogic = AND
	rowFilter      = map[string]interface{}{
		// "prev_state": []string{"no_data", "ok"},
		// "id": []int{36950876, 37393661, 37015953},
		// "tags": regexp.MustCompile("prebilling"),
		// "panel_id": 5,
		// "user_id": filterFunc(func(col *string) bool {
		// 	if i, err := strconv.Atoi(*col); err != nil {
		// 		return false
		// 	} else {
		// 		return i > 8000
		// 	}
		// }),
	}
)

var (
	firstLine  = fmt.Sprintf("DROP TABLE IF EXISTS `%s`", tableName)
	lastLine   = "UNLOCK TABLES;"
	createLine = "CREATE TABLE `"
	insertLine = "INSERT INTO `"
	OR         = 0
	AND        = 1

	rowFilterStrings []*string
	rowFilterMaps    []map[string]struct{}
	rowFilterRegex   []*regexp.Regexp
	rowFilterFunc    []filterFunc
)

func getFieldList(cs *string) []string {
	result := []string{}
	maxIdx := len(*cs)
	name := make([]byte, 0, maxIdx)
	inBrace := 0
	inQuot := false
	isBegin := true

	for idx := 0; idx < maxIdx; idx++ {
		c := (*cs)[idx]
		if c == '(' {
			inBrace += 1
		} else if c == ')' {
			inBrace -= 1
		} else if inBrace == 1 {
			if c == '`' {
				inQuot = !inQuot
				if !inQuot && len(name) > 0 {
					result = append(result, string(name))
					name = name[:0]
				}
			} else if c == ',' {
				isBegin = true
			} else if c == ' ' || c == '\t' {

			} else if inQuot && isBegin {
				name = append(name, c)
			} else {
				isBegin = false
			}
		}
	}
	return result
}

func getFilteredRows(line *string, cols []string) []string {
	rowBegin := 0
	colBegin := 0
	isRow := false
	isStr := false
	wasStr := false
	colNum := 0
	rowMatch := 0
	result := []string{}

	matchFunc := func(begin, end, n int, wasStr bool) int {
		match := false
		col := (*line)[begin:end]
		if wasStr {
			col = col[1 : len(col)-1]
		}
		if f := rowFilterStrings[n]; f != nil {
			match = (*f == col)
		} else if f := rowFilterMaps[n]; f != nil {
			_, match = f[col]
		} else if f := rowFilterRegex[n]; f != nil {
			match = f.MatchString(col)
		} else if f := rowFilterFunc[n]; f != nil {
			match = f(&col)
		}
		if match {
			return 1
		}
		return 0
	}

	maxIdx := len(*line)
	for idx := 0; idx < maxIdx; idx++ {
		c := (*line)[idx]
		if c == '\\' {
			idx += 1
			continue
		} else if c == '\'' {
			isStr = !isStr
			if isStr {
				wasStr = true
			}
		}
		if isStr {
			continue
		}
		if c == '(' {
			isRow = true
			wasStr = false
			rowBegin = idx
			rowMatch = 0
			colBegin = idx + 1
			colNum = 0
		} else if c == ')' {
			isRow = false
			rowMatch += matchFunc(colBegin, idx, colNum, wasStr)
			colNum++
			if (rowFilterLogic == OR && rowMatch > 0) || (rowFilterLogic == AND && rowMatch == len(rowFilter)) {
				result = append(result, (*line)[rowBegin:idx+1])
			}
		} else if isRow && c == ',' {
			rowMatch += matchFunc(colBegin, idx, colNum, wasStr)
			wasStr = false
			colBegin = idx + 1
			colNum++
		}
	}
	return result
}

func main() {
	const scanBufSize = 16 << 20
	file := os.Stdin

	if len(os.Args) > 1 {
		var err error
		file, err = os.Open(os.Args[1])
		if err != nil {
			log.Fatal(err)
		}
	}
	defer file.Close()

	scanner := bufio.NewScanner(file)
	scanBuf := make([]byte, scanBufSize)
	scanner.Buffer(scanBuf, scanBufSize)

	tableNameSearch := fmt.Sprintf("`%s`", tableName)
	tableNameNewReplace := fmt.Sprintf("`%s`", tableNameNew)
	tableFoundState := 0
	createLinesState := 0
	createString := ""
	filtersPrepared := false
	var fieldList []string
	for tableFoundState < 2 && scanner.Scan() {
		line := scanner.Text()

		// get table lines and change name
		if tableFoundState == 0 {
			if !strings.HasPrefix(line, firstLine) {
				continue
			}
			tableFoundState = 1
		} else if tableFoundState == 1 && strings.HasPrefix(line, lastLine) {
			tableFoundState = 2
		}

		// change name
		line1 := strings.Replace(line, tableNameSearch, tableNameNewReplace, 1)

		// construct field list
		if createLinesState < 2 {
			if createLinesState == 0 && strings.HasPrefix(line, createLine) {
				createLinesState = 1
			}
			if createLinesState == 1 {
				createString += line1
				if strings.HasSuffix(strings.TrimRight(line1, " \t\n\r"), ";") {
					createLinesState = 2
					fieldList = getFieldList(&createString)

					// prepare filters
					rowFilterStrings = make([]*string, len(fieldList))
					rowFilterMaps = make([]map[string]struct{}, len(fieldList))
					rowFilterRegex = make([]*regexp.Regexp, len(fieldList))
					rowFilterFunc = make([]filterFunc, len(fieldList))
					for idx, col := range fieldList {
						if filter, ok := rowFilter[col]; ok {
							switch filterTyped := filter.(type) {
							case int:
								p := strconv.Itoa(filterTyped)
								rowFilterStrings[idx] = &p
							case string:
								rowFilterStrings[idx] = &filterTyped
							case []int:
								m := make(map[string]struct{}, len(filterTyped))
								for _, i := range filterTyped {
									m[strconv.Itoa(i)] = struct{}{}
								}
								rowFilterMaps[idx] = m
							case []string:
								m := make(map[string]struct{}, len(filterTyped))
								for _, s := range filterTyped {
									m[s] = struct{}{}
								}
								rowFilterMaps[idx] = m
							case *regexp.Regexp:
								rowFilterRegex[idx] = filterTyped
							case filterFunc:
								rowFilterFunc[idx] = filterTyped
							default:
								log.Fatalf("Bad type in filter: %T", filterTyped)
							}
						}
					}
					filtersPrepared = true
				}
			}
		}

		// filter and print lines
		if strings.HasPrefix(line1, insertLine) {
			if !filtersPrepared {
				log.Fatalln("Filteres are not prepared! No CREATE statement was found!")
			}
			filtered := getFilteredRows(&line1, fieldList)
			if len(filtered) > 0 {
				insertLocalLine := line1[:strings.IndexByte(line1, '(')]
				fmt.Println(insertLocalLine + strings.Join(filtered, ",") + ";")
			}
			// for _, f := range filtered {
			// 	fmt.Println(f)
			// }
		} else {
			fmt.Println(line1)
		}
	}
}
