#!/bin/sh

export DEBFULLNAME="Kirill Nuzhdin"
export DEBEMAIL="knuzhdin@yandex-team.ru"
export SVN_SSH="ssh -l knuzhdin"


BINARY_VERSION="1.21.3"
PKGNAME="yandex-solomon-nginx-bin"
PAUSE=1


#-------------------------------------------------------------------


_pause() {
	local _sep="=============================================="

	echo $_sep$_sep
	echo
	if [ $PAUSE -eq 1 ] ; then
		echo -n "$1. Do you want to continue? [Y/n/s] "
		read answ

		if [ "$answ" = "S" -o "$answ" = "s" ] ; then
			echo "Skipping ..."
			return 2
		fi

		if [ "$answ" = "N" -o "$answ" = "n" ] ; then
			echo "Exiting ..."
			exit 0
		fi
	else
		echo "$1"
	fi
	echo
	echo $_sep$_sep
}


_chlog() {
	local _c

	svn up
	VERSION="`svn info | awk '/^Last Changed Rev:/ {print $NF}'`"
	COMMIT_MSG="`svn propget -r $VERSION --revprop svn:log`"
	DISTR="unstable"

	[ ! -f "debian/changelog" ] && _c="--create"

	_pause "Executing Debian changelog for '${DNAME}_${BINARY_VERSION}-${VERSION} ($DISTR)'"
	dch $_c --package $DNAME -v ${BINARY_VERSION}-$VERSION --urgency low \
		--distribution $DISTR r$VERSION $COMMIT_MSG
}


_svn() {
	_pause "Committing new changelog"
	eval svn ci -m \"$@\"
	svn up
}


_upload() {
	_pause "Uploading the package"
	cd .. && dupload --nomail ${DNAME}*.changes && cd -
}

_clean() {
	local _m _r _a


	_a="$@"
	if [ -z "$_a" ] ; then
		_m="all"
	else
		_m="leaving: $_a"
	fi


	_pause "Cleaning builds ($_m)"
	if [ $? -eq 2 ] ; then
		return
	fi


	find ../${DNAME}_* -maxdepth 1 -type f | \
	awk -vLF="$_a" 'BEGIN {
		split("deb upload build changes dsc gz", ae)
		split(LF, ac)
		for (i in ac)
			LEV[ac[i]]
		for (i in ae)
			if (!(ae[i] in LEV))
				EXT[ae[i]]
	}
	{
		e = $1
		gsub(/^.+\./, "", e)
		if (e in EXT)
			system("rm -vf " $1)
	}'
}

_build() {
	echo
	echo "Check libs: perl (libperl-dev) pcre (libpcre3-dev) zlib (zlib1g-dev) libxml2/libxslt (libxslt1-dev) gd (libgd-dev) geoIP (libgeoip-dev)"
	_pause "Building the package"
	debuild --no-tgz-check -e SSH_AUTH_SOCK

}

_ngclean() {
	rm -rvf etc usr var
}


#-------------------------------------------------------------------


noargs=true
while true; do
	case "$1" in
	-b|-u|-c|-a|-y|-h|-r)
		eval arg_${1#-}="Y"
		shift
		noargs=false
		;;
	*)
		break
		;;
	esac
done


#-------------------------------------------------------------------


if [ "$arg_y" = "Y" ] ; then
	PAUSE=0
fi


if [ "$arg_h" = "Y" ] || $noargs ; then
	echo "Usage:"
	echo "`basename $0` [-c] [-b] [-u] [-a] [-y] [-r] [-h]"
	echo "	-c add comment to changelog and increase version"
	echo "	-b build the package"
	echo "	-u upload the package"
	echo "	-a means do it all (changelog, build, upload)"
	echo "	-y answer yes to all questions"
	echo "	-r erase what is not needed"
	echo "	-h print this help"
	echo "	[-a] is equivalent to [-c -b -u]"
	exit 0
fi


#-------------------------------------------------------------------


set -e

NAME="`basename $0`"
cd ${0%$NAME}/$PKGNAME


DNAME=`pwd | awk -F "/" '{print $NF}'`


if [ "$arg_a" = "Y" ] ; then
	_chlog
	_clean
	_ngclean
	_build
	_upload
	_clean deb
	_ngclean
else
	if [ "$arg_c" = "Y" ] ; then
		_chlog $comm
	fi
	if [ "$arg_b" = "Y" ] ; then
		_clean
		_ngclean
		_build
	fi
	if [ "$arg_u" = "Y" ] ; then
		_upload
		_ngclean
		_clean deb
	fi
	if [ "$arg_r" = "Y" ] ; then
		_ngclean
		_clean deb
	fi
fi
