#!/bin/sh

DAEMON="/usr/sbin/nginx"
DEFAULTS="/etc/default/nginx"
CONFFILE="/etc/nginx/nginx.conf"

test_conf() {
	if [ -r $DEFAULTS ]; then
		. $DEFAULTS
	fi
	if ! $DAEMON -t -c $CONFFILE 2>/dev/null ; then
		echo "Configuration test failed..."
		$DAEMON -t -c $CONFFILE
		exit 1
	fi
}

if [ "$1" = "test" ] ; then
	test_conf
	echo "Configuration is OK!"
	exit
fi

PID=$(cat /Berkanavt/nginx/run/nginx.pid 2>/dev/null)
if [ ${#PID} -eq 0 ] ; then
	PID=$(pgrep -ox nginx)
	if [ ${#PID} -eq 0 ] ; then
		echo "nginx is not running, cannot manage it"
		exit 1
	fi
fi

case "$1" in
	kill)
		kill -s KILL $PID
		;;
	off)
		kill -s TERM $PID
		;;
	shutdown)
		kill -s QUIT $PID
		;;
	reload)
		test_conf
		kill -s HUP  $PID
		;;
	upgrade)
		test_conf
		kill -s USR2 $PID
		;;
	rotate)
		kill -s USR1 $PID
		;;
	*)
		echo "Usage: $0 [kill|off|shutdown|reload|upgrade|rotate|test]"
		exit 1
		;;
esac
