#!/bin/bash -e

BIN_DIR="$(dirname $(readlink -f $0))"

. "${BIN_DIR}/../etc/java.sh"
. "${BIN_DIR}/vmoptions.sh"

cd ${BIN_DIR}
exec ${JAVA} \
    -server -showversion \
    -classpath "${BIN_DIR}/libs/*" \
    ${JAVA_OPTS} \
    -XX:OnOutOfMemoryError="kill -9 %p" \
    -Djava.library.path="${BIN_DIR}/libs" \
    ru.yandex.solomon.project.manager.ProjectManagerMain "$@"
