{{toc to="h2"}}

==(problem)Проблематика

1. Проблема внутренних пользователей: для решения даже простых задач в Solomon UI приходится писать большую программу, что имеет следующие следствия:
    * Нужно буквально потратить много усилий, чтобы написать 15 строк в редакторе программы без подсветки и саджеста (((https://wiki.yandex-team.ru/solomon/product/query-math/#example пример))).
    * Программу тяжело отлаживать, если она сработала не так, как ожидалось — сложный отладочный вывод (только через аннотаци и график алерта).
    * Легко выстрелить себе в ногу и получить неожиданный результат из-за слишком широких возможностей, что генерирует обращения в саппорт.
2. Проблема внешних пользователей: в Cloud Monitoring UI (monitoring.cloud.yandex-team.ru) доступен только простой тип алерта (threhold), который не позволяет делать вычисления между разными запросами. Это **не дает возможности предоставить внешним пользователям алерты сервис-провайдеров**, т.к. в них часто используются алерты на отношения двух запросов (свободное место на диске, доля ошибок etc). 


==(principles)Принципы для выработки нового решения

1. Простые сценарии должны решаться просто.
2. Сложные сценарии (произвольный expression) должны остаться возможными для внутренних пользователей мониторинга (разработчики Яндекса).
3. Одинаково выглядящие вещи (контролы запросов) должны работать одинаково, на сколько это возможно, и в алертах и в дашбордах.
4. Решение для внутренних (разработчики Яндекса и Яндекс.Облака) и внешних (клиенты Яндекс.Облака) пользователей должно быть одинаковым: не делаем два разных решения, но можем внутренним пользователям давать больше функциональности !!для сохранения обратной совместимости или предоставления доступа к заведомо внутренней функциональности (eg. service discvovery через кондуктор)!!.


==(scenarios)Сценарии

На основе выборки из ~400 уже существующих программ алертов в Solomon UI получилась следующая классификация сценариев (таблица отсортирована по доле/частотности сценариев):

800x0:/solomon/product/query-math/design-doc/.files/image-1.png

++(((https://wiki.yandex-team.ru/solomon/product/query-math/sampling/ source)))++

При помощи добавления нового типа алерта Query Math
- Количество решаемых сценариев у внешних пользователей вырастает с 1 из 7 до 4 из 7. Доля алертов из тестовой выборки, которая решается при помощи Query Math вырастает с 46% до 74%
- Количество решаемых сценариев у внутренних пользователей остается 7 из 7, т.к. мы ничем не жертвуем. При этом 74% алертов из тестовой выборки в 400 алертов начинают решаться проще  без необходимости написания сложной программы expression-алерта.



==(solution)Описание решения (как все работает)

Вопрос количества типов алертов и конвертации между типами рассмотрен ниже: https://wiki.yandex-team.ru/solomon/product/query-math/design-doc/#convertation

===Query Math
  - Блок «Метрики» функционально повторяет Metics Explorer: пользователь указывает один или более запросов к метриками. Каждый запрос — это такой же компонент строки запроса, который используется в дашбордах и MX, с возможностью:
      - Переключаться между текстовым и токенизированным режимом
      - Писать многострочную программу с переменными (!!только для внутренних пользователей!!)
        - ⚠️ Уровень видимости переменных — это 1 запрос, так как иначе это добавляет еще один уровень сложности (можно ссылаться на запросы, а можно еще на отдельные переменные в запросе) и отладка алерта будет сложнее.
      - Перейти в Metrics Explorer
         - В MX передаются все запросы от текущего и выше, т.к. запрос может содержать ссылки на предыдущие запросы
      - Включить/выключить отображение результата запроса на графике алерта
        - ⚠️ Кнопка меняет свое поведение: раньше она полностью отключала выполнение запроса, а теперь кнопка только отключает отображение результата на графике. Запрос продолжает выполняться и передаваться в API, т.к. на результат запроса могут быть ссылки, см. далее.
  - ⚠️ В запросах !!нельзя!! использовать функции управления статусами алерта (alarm_if/warn_if/no_data_if/ok_if) — это возможно только в Expression-алерте (смотри далее)
    - ??TODO API: При попытке это сделать API должно возвращать ошибку «В таком-то запросе используется такая-то неразрешенная конструкция»??
  - ⭐️ Новая возможность запроса: посмотреть Preview запроса, которое отображается в модальном окне и визуализирует скаляры и timeseries этого конкретно запроса.
      - В API для отображения Preview передаются все запросы от текущего и выше,т .к. запрос может содержать ссылки на предыдущие запросы
  - ⭐️ Новая возможность запроса: у каждого запроса есть редактируемое имя, по которому можно ссылаться на результат этого запроса (см. далее).
  - ⭐️ Новая возможность запроса: в текстовом режиме запроса можно ссылаться на результаты выполнения других запросов по его имени. Результат выполнения запроса — то, что вернула последняя строка запроса (как в Erlang) без необходимости явно писать return, т.к. в языке нет условий, циклов и функций и нет необходимости прерывать выполнение многострочного запроса посередине. 
    - ⚠️ Контракт: запрос должен возвращать один или несколько временных рядов (timeseries). ??TODO API: Если это не так API должно вернуть ошибку.??
    - ⚠️ Ссылаться можно только на запросы, расположенные выше текущего, чтобы нельзя было создать нелинейный флоу выполнения программы алерта.
    - ??TODO UX: Интерфейс должен как-то решать проблему активации: как понять пользователю, что для использования ссылок нужно переключиться в текстовый режим? Подробнее ((https://wiki.yandex-team.ru/solomon/product/query-math/design-doc/#problemaaktivacii см. ниже)).??
    - ??TODO UX: Интерфейс должен давать понять пользователю ограничение на порядок запросов??

- В блоке «Условия срабатывания» пользователь выбирает
  - Функцию агрегации (скаляризации): среднее, сумма, минимум, максимум, количество, хотя бы одно значение, все значение (см. ((https://paste.yandex-team.ru/10232962 распределение)) по используемым функциям в уже созданных алертах).
  - К какому из запросов применяется функция.
  - Окно агрегации (за 5 минут, за N минут/часов/дней).
  - Предикат: больше или равно, больше, равно, не равно, меньше или равно, меньше.
  - Пороги для Alarm или Warn статуса.

    800x0:file:/solomon/product/query-math/design-doc/condition1.png

- В алерте можно задать только одно условие срабатывания.
- При добавлении нового запроса условие запроса автоматически перенастраивается на новый запрос.





===Expression
 - Нет отдельного блока «Метрики» и возможности вводить отдельные запросы.
 - Есть одно большое текстовое поле ввода, как в Solomon UI, в который текстом вводится программа алерта.
 - В программе !!(зел)можно!! использовать функции управления статусами алерта (alarm_if/warn_if/no_data_if/ok_if).




==(examples)Образ результата на примере сценариев 
===(single-query-example)Алерт на один запрос
Шаги:
1. Пользователь вводит Запрос A.
2. (опционально) При необходимости пользователь настраивает условие срабатывания — по умолчанию условие настроено на среднее значение запроса А за 5 минут.
2. Пользователь вводит пороги для перехода алерта в Alarm и/или Warn статус.

<{Макет
800x0:/solomon/product/query-math/design-doc/.files/image-2.png
}>

===(multiple-query-example)Отношение двух запросов или формула

Шаги:
1. Пользователь вводит Запрос A.
2. Пользователь вводит Запрос B.
3. Пользователь вводит Запрос С, переключает его в текстовый режим и вводит выражение, например, %%A / (A + B) * 100%%.
4. (опционально)  При необходимости пользователь настраивает условие срабатывания — по умолчанию условие настроено на среднее значение запроса C за 5 минут.
4. Пользователь вводит пороги для перехода алерта в Alarm и/или Warn статус.

<{Макет
800x0:file:/solomon/product/query-math/design-doc/scenarijj4.png
}>


===(expression-example)Expression алерт

Шаги:
1-∞. Пользователь пишет программу на кучу строк
<{Макет
800x0:file:/solomon/product/query-math/design-doc/expression-alert.png
}>

==(convertation)Конвертация уже существующих алертов
- Expression-алерты никак не конвертируются: для них меняется только дизайн страницы в Monitoring UI.
- C Threshold-алертами прямо сейчас действуем так:
   1. Делаем Threshold-алерт в Monitoring UI параллельным переносом из Solomon UI 
   2. Делаем миграцию Threshold алертов следующими шагами:
       - Делаем фича-флаг на проект, разрешающий создавать новые Threshold-алерты в проекте. Включаем его для тех проектов, где еще есть threshold-алерты. По дефолту флаг выключен.
       - Делаем API для конвертации Threshold-алерта в Query Math или Expression-алерт, чтобы пользователи сами могли сконвертировать свои алерты
       - Объявляем Threshold-алерты depricated, рассказываем как сконвертировать свои алерты, и **ставим дедлайн**, когда мы сами сконвертируем все оставшиеся threshold-алерты
 

===+Обсуждавшиеся ранее варианты
====Три типа алерта
Вариант №1: Для внутренних пользователей не конвертировать Threshold алерты и оставить их как есть сейчас. Для внешних сконвертировать в **новый** тип алерта Query Math. Для них нет проблемы миграции, т.к. у внешних пользователей нет API для управления алертами. 

В результате имеем три типа алертов:
1. Threshold (доступен только внутренним пользователям)
2. Query Math
3. Expression (доступен только внутренним пользователям)

Плюсы-минусы этого решения:
- !!Нужен макет Threshold алерта в Monitoring UI с поддержкой указания нескольких предикатов!!
- !!Продолжаем нести за собой неразвивающуюся legacy функциональность!!
- !!(зел)Не блокируемся на миграцию Threshold алертов при закрытии Solomon UI!!


====Миграция Threshold-алерта
Вариант №2: Для внутренних пользователей сконвертировать то, что можно в Query Math, а остальное — в Expression. 

Threshold-алерты с одним предикатом, а также алерты с двумя **одинаковыми** предикатами, использующими только статусы Warn и Alarm — сконвертировать в **новый** тип алерта Query Math алерты, а остальные — в Expression.

Одинаковые предикаты — те, у которых используются одинаковые фукнции агрегации и сравнения (больше/меньше и т.д).

Распределение по тому что во что конвертируется:
800x0:https://jing.yandex-team.ru/files/guschin/2022-07-07T10:31:32Z.589fd73.png
++(((https://wiki.yandex-team.ru/solomon/product/query-math/sampling/ source)))++

В результате имеем два типа алертов:
1. Query Math
2. Expression (доступен только внутренним пользователям)

Плюсы-минусы этого решения:
- !!(зел)Не нужны новые макеты!!
- !!(зел)Не тащим неразвивающуюся legacy функциональность!!
- !!Нужно стартовать проект по миграции!!: предупредить пользователей, обновляющих или читающих алерты через API, что в такой-то день, такой-то час модели алертов, которые они передают в API, изменятся.
  - Например, эта миграция могла бы выглядеть так: объявить, что Threshold-алерты остаются только в Solomon UI, который мы закроем в 1 декабря. До этого времени, сконвертируйте их либо в QM, либо в Expression, вот кнопка конвертации.



====Query Math как эволюционное развитие Threshold
Вариант №3. Не делать Query Math новым типом алерта, а попробовать расширить модель Threshold алерта для поддержки всей Query Math функциональности, сохранив обратную совместимость с уже существующими Threshold-алертами.

В результате имеем два типа алертов:
1. Threshold (с функциональностью Query Math)
2. Expression (доступен только внутренним пользователям)

Плюсы-минусы этого решения:
- !!(зел)Не нужны новые макеты!!
- !!(зел)Не тащим неразвивающуюся legacy функциональность!!, а эволюционное ее развиваем
- !!(зел)Не нужна миграция!!
- !!С ходу не ясно возможно ли это сделать, нужна дополнительная проработка!!. Возможно, модель threshold-алерта превратится в страшного кадавра






==(ux-todo)Постановка задач для дизайна/UX

===Проблема активации
Ключевая проблема: нужно дать понять пользователю, что он может ссылаться в запросе между запросами, и для этого нужно переключить запрос в текстовый режим.

Какие подходы уже пробовали:
1. Сделать под запросами две кнопки «Добавить запрос» — добавляет запрос в токензированном режиме и «Добавить выражение» — добавляет запрос в текстовом режиме. Люди не понимали без подсказок, что для ссылок между запросами нужно нажимать «добавить выражение», а также то, что обе кнопки добавляют одну и ту же сущность запроса просто в разных режимах. См. результаты исследования прототипа ((https://www.notion.so/Monitoring-Research-e0b0686d9d694ef3a0f5610069109578 в Notion)).
2. Сделать в блоке «условие срабатывания» возможность переключиться в режим «алерт сработает, если значение выражения будет …». В таком в условии срабатывания появляется запрос //сразу// в текстовом режиме. Отказались от этой идеи, т.к. это нарушало принцип одинаковости компонент запроса: запрос в условии срабатывания выглядел особенной сущснотью. См. также описание ((https://wiki.yandex-team.ru/solomon/product/query-math/design-doc/#variant ниже)).

===Проблема порядка запросов

В Query Math алерте мы разрешаем ссылаться только на запросы, расположены выше текущего, чтобы не допускать нелинейности в программах. Пользователю нужно каким-то образом давать понять что это так.

!!(зел)Можно!!
- Запрос А
- Запрос В 
- Запрос С ссылается на A и B

!!Нельзя!!, т.к. D ниже запроса C
- Запрос А
- Запрос С ссылается на A и D 
- Запрос D


===Проблема валидации запросов
1. Нужно уметь ругаться и не разрешать невалидные конструкции: запрос вернул не timeseries, в query math алерт используются функции alarm_if/*_if.
    - ??TODO API: Принять решение саджестить ли фнукции alarm_if/warn_if/error_if в текстовом режиме запроса???
2. Нужно уметь предупреждать (но не запрещать) об использовании deprecated функций.



==(questions)Вопросы

Ответом на каждый вопрос должен быть макет

====+1. Как будет выглядеть выбор типа алерта?
 - простой алерт (threshold в solomon ui)
 - поделить один запрос на другой (query math)
 - алерт с разладкой
 - алерт на тренд
 - сложная программа (expression в solomon ui)

800x0:file:/solomon/product/query-math/design-doc/choosealrerttype.png

====+2. Как будет выглядеть множественное условие срабатывания?

Прямо сейчас не делаем несколько условий срабатывания в Query Math алертах, так как:
1. Из тестовой выборки Expression-алертов 72% использует одно условие срабатывания и только 28% использует несколько. См. также ((https://yandexteam.sharepoint.com/:x:/r/sites/wiki-ms/_layouts/15/Doc.aspx?sourcedoc=%7BC6661546-6933-4511-B622-11D76EFDA7D3%7D&wdAllowInteractivity=True&wdDownloadButton=True&wdInConfigurator=True&action=edit таблицу с разметкой алертов)).
2. Из всех существующих 11 412 Threshold-алертов 90% использует один или два одинаковых предиката и только 10% больше предикатов. См. также ((https://wiki.yandex-team.ru/solomon/dev/rfc/rfc-021-query-math/#migracijathreshold-alerta раздел про миграцию)).

В будущем это место можно будет при необходимости расширить и поддержать несколько условий срабатывания в Query Math алертах: сейчас мы не делаем ничего такого, что закроет такую возможность.

====+3. Будут ли в условиях срабатывания варианты At least once/At all times?

Будут, т.к. аналитика показывает, что используется.

800x0:file:/solomon/product/query-math/design-doc/condition.png

====+4. Если появляется alarm_if/warn_if, то дизейблится условие срабатывания. Как это выглядит?

alarm_if/warn_if есть только в expression-алерте, там нет порогов.

800x0:file:/solomon/product/query-math/design-doc/expression-alert.png

====+5. Есть ли Preview/Go to MX в Expression-алерте и если да, то как работает?

Нет, т.к. ни preview ни MX не смогут визуализировать статус алерта, чем и является результат выполнения программы expression алерта. Визуализировать переменные тоже нельзя в общем случае, по словам кого:grodiychuk и кого:samarius

<[Самар Чокутаев, [30.06.2022 10:50]
[Forwarded from Владимир Гордийчук]
изменяя размер окна для загрузки ты меняешь результат программы

Самар Чокутаев, [30.06.2022 10:50]
[Forwarded from Владимир Гордийчук]
у тебя в программе могут быть всякие train, cut, drop_if, moving_..., etc

Самар Чокутаев, [30.06.2022 10:50]
[Forwarded from Владимир Гордийчук]
Ну нельзя график показать за большой интервал

Самар Чокутаев, [30.06.2022 10:50]
[Forwarded from Иван Цыбулин]
показать конечно можно

Самар Чокутаев, [30.06.2022 10:50]
[Forwarded from Иван Цыбулин]
просто когда делаешь что-то сложное, там цены на дрова
]>
800x0:file:/solomon/product/query-math/design-doc/expression-alert.png

====+6. Можно ли в запросах в блоке «Метрики» писать многострочные программы?

* Внешним пользователям Яндекс.Облака — нельзя. У них и сейчас нет такой возможности и не хочется ее давать, не понимая до конца какие сценарии это решает.
* Внутренним пользователям (разработчика Яндекса) — можно из соображения сохранения обратной совместимости.

====+7. Можно ли ссылаться в блоке «Метрики» на другие запросы (не только в выражении в условии срабатывания)?

Можно, т.к. запросы в блоке «Метрики» и в блоке «Условия срабатывания» одинаковые

800x0:file:/solomon/product/query-math/design-doc/scenarijj4.png

====+8. Является ли выражение в «Условии срабатывания» полностью таким же как и запросы в блоке «Метрики»?

Да, является.

=====+8.1. Если выражение в условии срабатывания может быть токенизировано (например, там написан только селектор с функциями), могу ли я переключить его в токенезированный вид?

Кажется, это выколотый случай, но да, можешь из прицнипа одинаковости запросов.

800x0:file:/solomon/product/query-math/design-doc/question8-1.png

=====+8.2. Могу ли я дублировать выражение в условии срабатывания?

Не можешь, т.к. еще одно выражение == еще одно условие срабатывания.

--!! ничего не понятно, нужно узнать у Владимира что не подходит!!--

Отказались от выражения в условии срабатывания.

====+9. Могу ли я изменять визуализацию графика алерта и настройки запроса?
 - Тип графика (линия, область, и т.д.), единицы измерения, выбор левой/правой оси, тип визуализации для каждого запроса в отдельности, цвета линий
 - Если ты указал для запроса единицу измерения «Байты», на графике стали отображаться гигабайты, могу ли я указать в пороге Alarm > 10 Gb?

**Ответ**: можешь принципа одинаковости и из соображения, что алерт — это практически Metrics Explorer, в нем все это уже есть.

====+10. Что показывает график алерта?

1. Прямо сейчас делаем как в Solomon UI: показываем результат вычисления алерта на окне. 
2. Решение с отображением графика алерта за произвольный интервал прорабатывается.


====+11. Как делать алерты со скалярами?

Например,
%%
Запрос А — sum(series_sum{...})
Запрос B – sum(series_sum{...})

Условие срабатывания (или запрос C)
A + B
alarm_if(A + B > 10)
%%

Если ты вернул скаляр, то пороги должны пропасть?

**A**: В Query Math такое невозможно, т.к. есть контракт, каждый запрос возвращает timeseries. Такие алерты придется делать в Expression.


====+12. Как быть с конвертацией threshold алертов?

Точно ли они все конвертируются? Надо ли так делать?

См. выше новый раздел документа про миграцию: https://wiki.yandex-team.ru/solomon/product/query-math/design-doc/#convertation


====+13. Как отключить компиляцию конкретного запроса?

Владимир: как отключить комплияцию конкретной квери? Раньше кнопка с глазом отключала выполнение всего запроса, а теперь она влияет только на видимость результата запроса на графике. Хочется иметь возможность выключить бажный запрос, но не потерять его текст.

**A**: Закомментировать содержимое запроса в текстовом режиме. Это уже работает и благодаря monaco даже стандартный хоткей это делает.

=====13.1 Как мигрировать уже созданные дашборды, у которых могут быть запросы с отжатыми глазами, которые не компилируются?

Мы меняем логику работы кнопки с глазиком в компоненте запроса: раньше она отключала компиляцию запроса, а теперь — только отображение результата запроса на графике. 

Так как компонент запроса одинаковый и используется как в алертах, так и в дашбордах, то эта новая логика приедет и в дашборды.

В системе уже есть дашборды, у которых выключены некоторые запросы. После изменения логики эти дашборды могут сломаться, если в выключенных запросах есть некомпилируемые выражения.

Всего есть 231 дашборд из 23885 в 104 проектах (((https://paste.yandex-team.ru/10479847 список))), в которых есть запросы с параметром %%"hidden": true%%. (((https://paste.yandex-team.ru/10479837 запрос))).

!!TODO: Как проверить компилируемость запросов?!!

====+ 14. Какой синтаксис ссылок на запросы?
Варианты:
- Без префикса, например, %%A%%
    - !!Легко сделать клеш между именем запроса и именем переменной внутри запроса!!
       - ??TODO API: При клеше нужно видеть человеко-понятную ошибку, а не было написано «переменна А уже определена»??
    - ...

- С префиксом, например, %%$A%%
  - !!(зел)Нельзя поклешиться, т.к. нельзя начинать переменные со знака доллара!!
  - ...



==+Обсуждавшиеся варианты решения

====Вариант guschin@
- В блоке «Условия срабатывания» пользователь выбирает
  - Функцию агрегации (скаляризации): среднее, сумма, минимум, максимум, количество, хотя бы одно значение, все значение (см. ((https://paste.yandex-team.ru/10232962 распределение)) по используемым функциям в уже созданных алерта)
  - К чему применяется функция: один из запросов или «Выражение» (см. далее)
  - Окно агрегации (за 5 минут, за N минут/часов/дней)
  - Предикат: больше или равно, больше, равно, не равно, меньше или равно, меньше.
  - Пороги для Alarm или Warn статуса
  - «Выражение» — это такой же запрос, как и в блоке «Метрики», который всегда появляется в текстовом режиме. В нем также можно ссылаться на результаты вычисления предыдущих запросов и т.д.

    800x0:file:/solomon/product/query-math/design-doc/image-3.png
    800x0:file:/solomon/product/query-math/design-doc/condition.png

Шаги для решения сценария отношения на двух запросов:
 1. Нажимаю «Добавить запрос», появлется Запрос А в токенах.
 2. Нажимаю «Добавить запрос», появлется Запрос В в токенах
 3. Условие срабатывания **автоматически** переключается в режим «Выражение», с подсказкой, что сюда можно писать запрос со ссылками на другие запросы.
 4. Ввожу выражение %%A / (A + B) * 100%% в блок условие срабатывания.


Плюсы-минусы этого решения:
- !!Владимир: нарушается принцип одинаковости всех запросов: «выражение» в условии срабатывания выглядит особенным!!
  - Смущает то, что выражение в блоке «Условие срабатывания» оторвано от всех остальных запросов (хотя они выглядят и работают одинаково), из чего можно сделать вывод, что выражение — чем-то особенное. Это может повлиять на дизайн API.
- !!(зел)Нет необходимости менять порядок запросов!! (см. далее)

====Вариант gordiychuk@
800x0:file:/solomon/product/query-math/design-doc/scenarijj4.png

Отличия от варианта guschin@: нет выражения в условии срабатывания – выражение всегда пишется в блоке «метрики».

Шаги для решения сценария отношения на двух запросов:
 1. Нажимаю «Добавить запрос», появлется Запрос А в токенах.
 2. Нажимаю «Добавить запрос», появлется Запрос В в токенах.
 3. Сразу же **автоматически** появляется третий запрос в текстовом виде, называющийся «Выражение»/«Запрос С», с подсказкой, что сюда можно писать запрос со ссылками на другие запросы. Условие срабатывания переключается на «Выражение»/«Запрос С».
 5. Ввожу выражение %%A / (A + B) * 100%% в «Выражение»/«Запрос С».

Плюсы-минусы этого решения
- !!(зел)Выполняется принцип одинаковости всех запросов!!
- !!Появляется необходимость уметь менять порядок запросов!!
    - Кейс: ввел запрос А, запрос В, запрос %%A / (A + B) * 100%% и после этого нужно добавить еще один запрос, на который я хочу сослаться в выражении.
    - Можно было бы разрешить ссылаться в произвольный запрос, а не только в те, которые выше, но это позволяет создавать программы с нелинейным флоу — это затрудняет отладку.

====Вариант samarius@
file:/solomon/product/query-math/design-doc/photo2022-06-3017-40-51.jpg

Отличия от варианта gordiychuk@: нет выражения в условии срабатывания – выражение всегда пишется в блоке «метрики» и располагается //последним// (как в DataDog).

Шаги для решения сценария отношения на двух запросов (такой же как во варианте gordiychuk@):

 1. Нажимаю «Добавить запрос», появлется Запрос А в токенах.
 2. Нажимаю «Добавить запрос», появлется Запрос В в токенах.
 3. Сразу же **автоматически** появляется третий запрос в текстовом виде, называющийся «Выражение»/«Запрос С», с подсказкой, что сюда можно писать запрос со ссылками на другие запросы. Условие срабатывания переключается на «Выражение»/«Запрос С».
 5. Ввожу выражение %%A / (A + B) * 100%% в «Выражение»/«Запрос С».

Плюсы-минусы этого решения
- !!Андрей: нарушается принцип одинаковости всех запросов!!
  - Могу ли я дублировать выражение?
  - Могу ли я его удалить и если да, то как его вернуть? 
  - Могу ли я поменять его название?
  - Если делать точно как в DataDog, то там выражение есть всегда, оно одно, его нельзя удалить и оно особенное, не такое как другие запросы

- !!(зел)Нет необходимости менять порядок запросов!!

====Вариант утопический
Если бы все запросы всегда были текстовыми, то не было бы проблемы «двух кнопок», не было бы необходимости дополнительно подсказывать, что для ссылок на запросы нужно переключаться в текстовый режим и соответственно добавлять еще один запрос (выражение) в условия срабатывания.

К сожалению, прямо сейчас так сделать нельзя, поскольку исследование по Query Math показывает, что пользователи 50/50 используют токенизированный и текстовый режим. Возможно, это распределение изменится, если текстовый режим будет дополнительно прокачен (автодполнение, саджесты, подсветка кода).

==(next-steps)Следующие шаги
1. Поддержка Query Math не только в алертах, но и дашбордах
2. Инструмент (кнопка в UI и/или API) для конвертации простых Expression-алертов в Query Math алерты?


