#!/usr/bin/env python3

# SOLOMON-5823

import argparse
import json
import os
import sys

import solomon_api

OAUTH_TOKEN_ENV_VAR = "OAUTH_TOKEN"

def main():
    if OAUTH_TOKEN_ENV_VAR not in os.environ:
        print("OAuth token isn't specified in", OAUTH_TOKEN_ENV_VAR, "env variable", file=sys.stderr)
        sys.exit(100)

    oauth_token = os.environ[OAUTH_TOKEN_ENV_VAR]

    client = solomon_api.V2(oauth_token)

    alerts = client._get_json("/projects/solomon/alerts/e48acd66-6a84-461f-af58-96a4c0fc1027/subAlerts?filterByEvaluationStatus=ALARM&pageSize=500")

    for a in alerts["items"]:
        projectId = a["labels"]["projectId"]
        shardId = a["labels"]["shardId"]
        
        shard = client._get_json("/projects/{}/shards/{}".format(projectId, shardId))
        hosts = shard["hosts"]
        serviceId = shard["serviceId"]
        port = client._get_json("/projects/{}/services/{}".format(projectId, serviceId))["port"]

        sas_fetcher = hosts[0] if 'sas' in hosts[0] else hosts[1]
        vla_fetcher = hosts[0] if 'vla' in hosts[0] else hosts[1]

        sas_targets = ["{}:{}".format(h["host"], port) for h in client._get_json(
                "/projects/{}/shards/{}/targets?fetcherHost={}&pageSize=all&status=CONNECT_FAILURE".format(
                    projectId,
                    shardId,
                    sas_fetcher
                ))["result"]]

        vla_targets = ["{}:{}".format(h["host"], port) for h in client._get_json(
                "/projects/{}/shards/{}/targets?fetcherHost={}&pageSize=all&status=CONNECT_FAILURE".format(
                    projectId,
                    shardId,
                    vla_fetcher
                ))["result"]]

        diff = list(set(sas_targets)-set(vla_targets))
        diff.sort()

        if len(diff) == 0:
            continue

        print("<{{projectId={}, shardId={}".format(projectId, shardId))
        print("Shard URL: https://solomon.yandex-team.ru/admin/projects/{}/shards/{}/status?status=CONNECT_FAILURE".format(projectId, shardId))

        print("sas_fetcher: {}\nvla_fetcher: {}\n".format(sas_fetcher, vla_fetcher))
        print("%%")
        # print("Diff:\n")
        print("\n".join(diff))
        print("%%\n}>")

if __name__ == '__main__':
    main()
