#!/bin/bash -e


#dc="man"
dc="myt"

z2key="KEY"
version="3229175.trunk"

stime=600


log() {
	/bin/date "+%Y-%m-%d [%H:%M:%S] -  $*"
}

graphite_web() {
	local _dc=$1 _action=$2 _server
	if [ "$_dc" = "myt" ] ; then
		_dc="sas"
	fi
	for _server in `echo mega-graphite-{ps-,gr-,}${_dc}` ; do
		log "do ${_server}*"
		ssh root@${_server}-00.search.yandex.net "service mega-graphite-web $_action" &
		ssh root@${_server}-01.search.yandex.net "service mega-graphite-web $_action" &
		wait
		sleep $stime
	done
}

solomon_front() {
	local _dc=$1 _action=$2 _server _servers
	_servers="`echo solomon-stp-${_dc}-{00..31}.search.yandex.net`"
	log "do ${_servers}"
	for _server in $_servers ; do
		ssh root@$_server "service yandex-solomon-frontend $_action" &
	done
	wait
}

solomon_handle() {
	local _dc=$1 h
	BEAN="ru.yandex.salmon.stockpile.server.shard.StockpileShardLoader"
	METHOD="forceShardsLogsSnapshot"
	DESC="(J)Ljava/lang/String;"
	for h in `echo solomon-stp-${_dc}-{00..31}.search.yandex.net` ; do
		curl -s "http://$h:8606/manager?bean=$BEAN&method=$METHOD&desc=$DESC&invoke=1&p0=200" > /dev/null
		log "$h [OK]"
	done
}

z2_edit_items() {
	local _config=$1 _apikey=$2 _pkg=$3 _version=$4
	_data="configId=$_config&apiKey=$_apikey&items=[{\"name\":\"$_pkg\",\"version\":\"$_version\"}]"
	log "Z2 edit config ($_config -> $_pkg=$_version):"
	/usr/bin/curl -qs --data "$_data" 'https://z2.yandex-team.ru/api/v1/editItems'
	echo
	log "Done"
}

z2_update_start() {
	local _config=$1 _apikey=$2
	_data="configId=$_config&apiKey=$_apikey"
	log "Z2 run update ($_config):"
	/usr/bin/curl -qs --data "$_data" 'https://z2.yandex-team.ru/api/v1/update'
	echo
	log "Done"
}

z2_check_update() {
	local _config=$1 _apikey=$2
	/usr/bin/curl -qs "https://z2.yandex-team.ru/api/v1/updateStatus?configId=$_config&apiKey=$_apikey"
	echo
}

z2_wait_update() {
	local _config=$1 _apikey=$2 updateStatus result
	while true; do
		z2result=`z2_check_update $_config $_apikey`
		updateStatus=`echo $z2result | awk 'gsub(/["{}:]/, " ") && sub(/^.+updateStatus/, "") {print $1}'`
		result=`echo $z2result | awk 'gsub(/["{}:]/, " ") && sub(/^.+result/, "") {print $1}'`
		if [ "$updateStatus" = "FINISHED" ] ; then
			if [ "$result" = "SUCCESS" ] ; then
				log "Z2 Success"
				return 0
			else
				log "Z2 Failure: $z2result"
				return 1
			fi
		fi
		log "$z2result"
		sleep 10
	done
}

all_off() {
	local _dc=$1
	log "Stopping graphite-web"
	graphite_web $_dc stop
	log "Stopping solomon-frontend"
	solomon_front $_dc stop
	log "Pull solomon-stockpile handle"
	solomon_handle $_dc
	sleep 600
	log "OFF DONE"
}

all_on() {
	local _dc=$1
	log "Starting solomon-frontend"
	solomon_front $_dc start
	log "Starting graphite-web"
	graphite_web $_dc start
	log "ON DONE"
}


z2cfg="SOLOMON_STP_`echo $dc | tr '[a-z]' '[A-Z]'`"

case $1 in
	"all")
		all_off $dc
		z2_edit_items $z2cfg $z2key yandex-solomon-stockpile $version
		z2_update_start $z2cfg $z2key
		sleep 10
		if z2_wait_update $z2cfg $z2key ; then
			sleep 600
			all_on $dc
		else
			log "NOT STARTING!"
		fi
		;;
	"off")
		all_off $dc
		;;
	"on")
		all_on $dc
		;;
	"ls")
		log "`z2_check_update $z2cfg $z2key`"
		stime=0
		solomon_front $dc status
		graphite_web $dc status
		;;
	*)
		echo "Try again"
		;;
esac

