#!/bin/bash -e

make() {
    logbroker -s ${LB_CLOUD} schema create topic ${LB_CLOUD_TOPIC} -p ${PARTITION_COUNT} -y
    logbroker -s ${LB} schema create topic ${LB_MIRROR_TOPIC} -p ${PARTITION_COUNT} -y
    logbroker -s ${LB_CLOUD} permissions grant --path ${LB_CLOUD_TOPIC} --subject ${SA_MIRROR_ACCOUNT}@as --permissions ReadTopic -y
    logbroker -s ${LB_CLOUD} schema create read-rule -t ${LB_CLOUD_TOPIC} -c shared/remote-mirror --all-original -y
    logbroker -s ${LB} schema create remote-mirror-rule -t ${LB_MIRROR_TOPIC} -c sas --src-cluster ${LB_CLOUD} --src-topic ${LB_CLOUD_TOPIC} --src-consumer shared/remote-mirror --iam-key-file ${SA_MIRROR_KEY_FILE} -y
    logbroker -s ${LB} schema create consumer ${LB_TRANSFER_CONSUMER} -y
    logbroker -s ${LB} permissions grant --path ${LB_MIRROR_TOPIC} --subject robot-lf-dyn-push@staff --permissions ReadTopic -y
    logbroker -s ${LB} permissions grant --path ${LB_TRANSFER_CONSUMER} --subject robot-lf-dyn-push@staff --permissions ReadAsConsumer -y
    logbroker -s ${LB} schema create read-rule --topic ${LB_MIRROR_TOPIC} --consumer ${LB_TRANSFER_CONSUMER} --all-original -y
}

preprod() {
    # https://yav.yandex-team.ru/secret/sec-01esbrr667re3f3jpmr8yh8hrr/explore/version/ver-01f7nww4x16af4ss72xfs4pqf8
    export SA_KEY_FILE=/Berkanavt/keys/solomon/preprod/yc.monitoring.fetcher-sa.json

    # https://yav.yandex-team.ru/secret/sec-01esbrr667re3f3jpmr8yh8hrr/explore/version/ver-01f7nww4x16af4ss72xfs4pqf8
    # sa-logbroker-mirrorer
    SA_MIRROR_ACCOUNT=bfbj2i1ojh5q3m5umntv
    SA_MIRROR_KEY_FILE=~/logbroker-mirrorer-key.json

    LB_CLOUD=yc-logbroker-preprod
    LB=logbroker

    # name-resolver
    {
        PARTITION_COUNT=1
        LB_CLOUD_TOPIC=/yc.monitoring.cloud/name-resolver/search-resource-issues
        LB_MIRROR_TOPIC=/monitoring/cloud/preprod/name-resolver/search-resource-issues
        LB_TRANSFER_CONSUMER=/monitoring/cloud/preprod/name-resolver/data-transfer-consumer
        make
    }

    # coremon
    {
        PARTITION_COUNT=10
        LB_CLOUD_TOPIC=/yc.monitoring.cloud/coremon-unknown-references-topic
        LB_MIRROR_TOPIC=/monitoring/cloud/preprod/coremon-unknown-references-mirror-topic
        LB_TRANSFER_CONSUMER=/monitoring/cloud/preprod/coremon-data-transfer-consumer
        make
    }
}

prod() {
    # https://yav.yandex-team.ru/secret/sec-01evvgkgrgy6tvgrhgpq722e1f/explore/versions
    export SA_KEY_FILE=/Berkanavt/keys/solomon/cloud-prod/yc.monitoring.fetcher-sa.json

    # https://yav.yandex-team.ru/secret/sec-01evvgkgrgy6tvgrhgpq722e1f/explore/versions
    # fetcher-sa-logbroker-mirrorer
    SA_MIRROR_ACCOUNT=ajervo0f31fjfkil467p
    SA_MIRROR_KEY_FILE=~/logbroker-mirrorer-key_prod.json

    LB_CLOUD=yc-logbroker
    LB=logbroker

    # name-resolver
    {
        PARTITION_COUNT=1
        LB_CLOUD_TOPIC=/yc.monitoring.cloud/name-resolver/search-resource-issues
        LB_MIRROR_TOPIC=/monitoring/cloud/prod/name-resolver/search-resource-issues-mirror-topic
        LB_TRANSFER_CONSUMER=/monitoring/cloud/prod/name-resolver/data-transfer-consumer
        make
    }

    # coremon
    {
        PARTITION_COUNT=10
        LB_CLOUD_TOPIC=/yc.monitoring.cloud/coremon/unknown-references-topic
        LB_MIRROR_TOPIC=/monitoring/cloud/prod/coremon/unknown-references-mirror-topic
        LB_TRANSFER_CONSUMER=/monitoring/cloud/prod/coremon/data-transfer-consumer
        make
    }
}

preprod
prod
