#!/bin/sh -e

if [ $# -lt 2 ]; then
    echo "Usage: $0 {cfg|stp|core|all} <branch>"
    echo
    echo "   cfg - build packages with configs "
    echo "  core - build packages with core services {alerting, backend, coremon, fetcher, gateway}"
    echo "   stp - build packages with stockpile"
    echo "   all - build all packages"
    exit 1
fi

. ./packages.inc

case "$1" in
    cfg) PACKAGES="${PACKAGES_CFG}" ;;
    core) PACKAGES="${PACKAGES_CORE}" ;;
    stp) PACKAGES="${PACKAGES_STP}" ;;
    all) PACKAGES="${PACKAGES_CORE} ${PACKAGES_STP}" ;;
    *)
        echo "unknown target option: $1"
        exit 1
        ;;
esac

case "$2" in
    trunk) BRANCH="trunk" ;;
    stable-*) BRANCH="branches/solomon/$2" ;;
    *)
        echo "invalid branch name: $2"
        echo "expected 'trunk' or some stable branch (e.g. 'stable-2018-12-10')"
        exit 1
        ;;
esac

ARCADIA_DIR="../../.."
YA="${ARCADIA_DIR}/ya"
SBCTL="$ARCADIA_DIR/tools/sandboxctl/bin/sandboxctl"

if [ ! -x ${SBCTL} ]; then
    echo "build sandboxctl"
    ${YA} make -r --checkout "$(dirname $SBCTL)"
fi

PKGS=$(echo ${PACKAGES} | tr ' ' '\n' | sort -u | sed -E 's|^(.*)$|solomon/packages/\1/pkg.json|' | tr '\n' ';')

${SBCTL} create \
    --json \
    --wait \
    --name YA_PACKAGE \
    --desc "Build Solomon Packages for Yandex.Cloud" \
    --ctx-opt packages=${PKGS} \
    --ctx-opt checkout_arcadia_from_url=arcadia:/arc/${BRANCH}/arcadia \
    --ctx-opt checkout=true \
    --ctx-opt publish_to=yandex-cloud \
    --ctx-opt dupload_max_attempts=5 \
    --ctx-opt key_user=robot-solomon \
    --ctx-opt kill_timeout=1800

${YA} notify "Packages build is done"

