#!/bin/sh -e

if [ $# -lt 2 ]; then
    echo "Usage: $0 {cfg|stp|core|all} <version>"
    exit 1
fi

. ./packages.inc

case "$1" in
    cfg) PACKAGES="${PACKAGES_CFG}" ;;
    core) PACKAGES="${PACKAGES_CORE}" ;;
    stp) PACKAGES="${PACKAGES_STP}" ;;
    all) PACKAGES="${PACKAGES_CORE} ${PACKAGES_STP}" ;;
    *)
        echo "unknown target option: $1"
        exit 1
        ;;
esac

VERSION="$2"

for package in ${PACKAGES}; do
    echo "\033[0;31m [*] Dmoving ${package}...\033[0m"
    ssh dupload.dist.yandex.ru "sudo dmove yandex-cloud stable ${package} ${VERSION} unstable"
done
