#!/bin/sh -e

if [ $# -eq 0 ]; then
    echo "Usage: $0 {prod|cloud-pre|cloud-prod}"
    exit 1
fi

case "$1" in
    prod)
        GATEWAY_HOST="solomon-kfront-sas-00.search.yandex.net"
        FETCHER_HOST="solomon-fetcher-sas-000.search.yandex.net"
        STORAGE_HOST="solomon-storage-sas-000.search.yandex.net"
        ;;
    cloud-pre)
        GATEWAY_HOST="solomon-gateway-00.svc.cloud-preprod.yandex.net"
        FETCHER_HOST="solomon-core-00.svc.cloud-preprod.yandex.net"
        STORAGE_HOST="solomon-stockpile-00.svc.cloud-preprod.yandex.net"
        ;;
    cloud-prod)
        GATEWAY_HOST="solomon-gateway-00.svc.cloud.yandex.net"
        FETCHER_HOST="solomon-core-sas-00.svc.cloud.yandex.net"
        STORAGE_HOST="solomon-stockpile-sas-00.svc.cloud.yandex.net"
        ;;
    *)
        echo "unknown location: $1"
        exit 1
        ;;
esac

CMD="dpkg-query --showformat='\${Package}=\${Version}\n' --show 'yandex-solomon*' | grep stable | sort"

echo "== [ gateway ] ==="
ssh $GATEWAY_HOST $CMD

echo "== [ core/fetcher ] ==="
ssh $FETCHER_HOST $CMD

echo "== [ storage ] ==="
ssh $STORAGE_HOST $CMD

