import datetime
import json
import sys

from yc_service_account import create_service_account_token

TOKEN_TTL = datetime.timedelta(days=365)


def main():
    if len(sys.argv) != 2:
        print("usage:", sys.argv[0], "<account_data.json>")
        sys.exit(1)

    accound_data = json.load(open(sys.argv[1]))
    token = create_service_account_token(
        accound_data["service_account_id"],
        accound_data["service_account_login"],
        accound_data["folder_id"],
        accound_data["key_id"],
        accound_data["private_key"].encode("ascii"),
        expires_in=TOKEN_TTL)
    print(token.decode("ascii"))


if __name__ == "__main__":
    main()
