#!/usr/bin/env python3

import sys
import os
import solomon_api

def main():
    token = os.getenv("TOKEN")
    solomon = solomon_api.V2(token, env="PRESTABLE")
    projects = solomon.list_projects()

    count = len(projects)
    left = count

    for project in projects:
        project_id = project['id']
        if project_id.startswith("yasm_pull_sts1_"):
            continue
        if project_id.startswith("yasm_pull_sts2_"):
            continue

        if project_id.startswith("yasm_pull_"):
            print("deleting project", project_id)
            solomon.delete_project(project_id)

        left -= 1
        print("\r%d / %d" % (left, count))


if __name__ == "__main__":
    main()
