#!/bin/bash -e
#
# Run on one of the storage host, e.g. solomon-storage-sas-000.seaarch.yandex.net
#
# To delete single shard run:
#   ./delete_shard_meta.sh <shard_id>
#
# To delete many shards run:
#   ./delete_shard_meta.sh <file_with_shard_ids>
#

if [ $# -eq 0 ]; then
    echo "Usage: $0 {shardId | file_with_shard_ids}"
    exit 1
fi

delete_shard() {
    shardId="$1"
    numId=$(kikimr -s solomon-kfront-sas-00 db yql --text "select cast(numId as Uint64) from [/Kfront/Solomon/Config/V2/Shard] where id = \"${shardId}\";" | sed -En 's/.*"column0": ([0-9]+)}/\1/p')

    tableName="/Solomon/Solomon/Coremon/V1/Metrics_$(printf "%02x" $((${numId} & 0x3f)))"
    count=$(kikimr db yql --text "select count(*) from [${tableName}] where shardId = ${numId};" | sed -En 's/.*"column0": ([0-9]+)}/\1/p')

    echo "deleting ${count} rows of shard ${shardId} from ${tableName}"

    for h in $(seq 0 255); do
        echo -ne "[$h/255]\033[0K\r"
        kikimr db yql --text "delete from [${tableName}] where shardId = ${numId} and hash <= 0x$(printf "%02x" $h)ffffff; commit;"
    done
}

if [ -f $1 ]; then
    for id in $(cat $1); do
        while [ true ]; do
            delete_shard $id && break
            echo "retry after 10s ..."
            sleep 10
        done
    done
else
    delete_shard $1
fi

