#!/bin/bash -e
#
# Run on one of the storage host, e.g. solomon-storage-sas-000.seaarch.yandex.net
#
# To dump metadata from shard run:
#   ./dump_shard_meta.sh <shard_id>
#

if [ $# -eq 0 ]; then
    echo "Usage: $0 <shardId>"
    exit 1
fi

shardId="$1"
numId=$(kikimr -s solomon-kfront-sas-00 db yql --text "select cast(numId as Uint64) from [/Kfront/Solomon/Config/V2/Shard] where id = \"${shardId}\";" | sed -En 's/.*"column0": ([0-9]+)}/\1/p')

tableName="/Solomon/Solomon/Coremon/V1/Metrics_$(printf "%02x" $((${numId} & 0x3f)))"
count=$(kikimr db yql --text "select count(*) from [${tableName}] where shardId = ${numId};" | sed -En 's/.*"column0": ([0-9]+)}/\1/p')

echo "dump ${count} rows of shard ${shardId} from ${tableName}"
kikimr db readtable --from ${numId} --to ${numId} --to-inclusive --no-header ${tableName} > ${shardId}.csv
