#!/usr/bin/env python3

import urllib.request, urllib.parse, urllib.error


HOSTS = [ "solomon-storage-sas-%03d" % i for i in range(0, 64) ]

COLUMNS = [
    ("RSS", {'sensor': 'proc.self.rssBytes'}),
    ("Heap", {'sensor': 'jvm.memory.used', 'pool': '*'}),
    ("NonHeap", {'sensor': 'jvm.buffer.used', 'pool': '*'}),
    ("GcTime", {'sensor': 'jvm.gc.timeMs', 'gc': '*', 'transform': 'asap'})
]

URL_PREFIX = "/?project={{project}}&cluster=production&service={{service}}&"

def write_row(host):
    print("rows {")
    for name, params in COLUMNS:
        element = params.copy()
        element["host"] = host
        element["graph"] = "auto"
        url = URL_PREFIX + urllib.parse.urlencode(element)
        print("  elements {")
        print("    url: \"%s\"" % url)
        print("    title: \"%s: %s\"" % (name, host))
        print("  }")
    print("}")


def main():
    for host in HOSTS:
        write_row(host)


if __name__ == "__main__":
    main()

