#!/bin/sh -e


ARCADIA="$(readlink -f ../../../)"
YA="${ARCADIA}/ya"

if [ $# -lt 2 ]; then
    echo "usage: {sas|vla} <file_with_metric_ids>"
    exit 1
fi

case "$1" in
    sas) cluster="PROD_STOCKPILE_SAS" ;;
    vla) cluster="PROD_STOCKPILE_VLA" ;;
    *)
        echo "unknown stockpile cluster: $1"
        exit 1
esac

${YA} tool java15 --enable-preview --class-path '../../tools/misc-tools/misc-tool/*:' ru.yandex.solomon.tool.cleanup.DeleteMetricsFromStockpile ${cluster} $2 --force

