#!/bin/sh -e

if [ $# -eq 0 ]; then
    echo "Usage: $0 {deploy|start|stop|cleanup}"
    exit 1
fi

./local_ydb $1 \
    --ydb-working-dir ${PWD}/my-ydb \
    --ydb-binary-path ${PWD}/kikimr \
    --ydb-udfs-dir ${PWD}

mon_port=$(jq '.nodes["1"].mon_port' ${PWD}/my-ydb/ydb_recipe.json)
grpc_port=$(jq '.nodes["1"].grpc_port' ${PWD}/my-ydb/ydb_recipe.json)

echo "Monitoring: http://$(hostname):${mon_port}/"
echo "      gRPC: $(hostname):${grpc_port}"

