#!/bin/bash

set -o pipefail
set -e

fail() {
    >&2 echo $1
    exit 1
}

print_usage() {
cat << EOF
Usage: ${0##*/} [-h] [GROUP]
Resolve conductor group to hosts and create config for interconnect cluster that can be used in fetcher.

    -h      display this message and exit

EOF
}

while getopts "h?:" opt; do
    case "${opt}" in
    h|\?)
        print_usage
        exit 0
        ;;
    esac
done

shift "$((OPTIND-1))"

group=$1
test -z $group && fail "Group is not specified"

hosts=$(curl -sf "https://c.yandex-team.ru/api/groups2hosts/${group}")
test -z "${hosts}" && fail "Error while getting hosts for group ${group} from conductor"

nodeCount=$(echo "${hosts}" | wc -l)

for host in ${hosts}; do
    i=$(echo "${host}" | cut -f1 -d"." | rev | cut -f1 -d"-" | rev)
    nodeId=$((10#$i + 1))

    if (( nodeId<nodeCount )); then
        sep=","
    else
        sep=""
    fi

    echo -e "{\n    Hostname: \"${host}\"\n    Port: 4620\n    IpAddress: \"$(host ${host} | cut -f5- -d' ')\"\n    NodeId: ${nodeId}\n}${sep}"
done
