#!/bin/bash -e

ARCADIA_DIR=$(find "$(svn info | grep "Working Copy Root" | cut -f2 -d: | tr -d ' ')" -maxdepth 3 -type f -name .arcadia.root | xargs dirname)
YA="${ARCADIA_DIR}/ya"
SOLOMON_SOURCE_ROOT="${ARCADIA_DIR}/solomon/j"

WD=$(cd $(dirname $0); pwd)
OUT=${WD}/out

rm -rf "${OUT}"
mkdir -p "${OUT}/libs"

. "${WD}/config.sh"

echo "Building..."
cd "${SOLOMON_SOURCE_ROOT}"
make clean build
cd ./solomon-tool
$YA make
cp $(readlink -f ./solomon-tool.jar) "${OUT}/libs"
cp -r "${SOLOMON_SOURCE_ROOT}/target/solomon-coremon/." "${OUT}/libs/"
cp -r "${SOLOMON_SOURCE_ROOT}/../etc" "${OUT}"
cp ${WD}/run_mb.sh ${WD}/config.sh ${OUT}

echo "Removing old build..."
parallel-ssh -i -H "${TARGET_METABASE_HOSTS}" "rm -rf ${REMOTE_WORKDIR}; mkdir -p ${REMOTE_WORKDIR}"
cd ${OUT}
echo "Uploading new build..."
parallel-scp -r -H "${TARGET_METABASE_HOSTS}" "." "${REMOTE_WORKDIR}"
