#!/bin/bash -e

WD=$(cd $(dirname $0); pwd)
. "${WD}/config.sh"

REMOTE_LOG=${REMOTE_WORKDIR}/mig_mb_log.txt

tails() {
    parallel-ssh -i -H "${SOURCE_HOSTS}" "tail -n 5 $REMOTE_LOG"
}

tails_alive() {
    parallel-ssh -i -H "${SOURCE_HOSTS}" "jps | grep Meta | while read line; do tail -n 5 $REMOTE_LOG; done"
}

check_impl() {
    PROCS=$(parallel-ssh -i -H "${SOURCE_HOSTS}" "jps | grep MetabaseTransfer | wc -l" | grep -v SUCCESS | paste -sd+ | bc)
    echo "processes still running: $PROCS/$(echo $SOURCE_HOSTS | sed -e "s/ /\n/g" | wc -l)" 1>&2

    PROCESSED=$(parallel-ssh -i -H "${SOURCE_HOSTS}" "cat $REMOTE_LOG | grep Processed | tail -n 1" | grep Processed | sed -e "s/\// /g" | awk '{ print $2 }' | paste -sd+ | bc)
    TOTAL=$(parallel-ssh -i -H "${SOURCE_HOSTS}" "cat $REMOTE_LOG | grep Processed | tail -n 1" | grep Processed | sed -e "s/\// /g" | awk '{ print $3 }' | paste -sd+ | bc)
    echo "shards transferred/total: $PROCESSED/$TOTAL" 1>&2
    TOTAL_SENSORS=$(parallel-ssh -i -H "${SOURCE_HOSTS}" "cat $REMOTE_LOG | grep 'in source DAO'" | grep DAO | awk '{ print $1 }' | paste -sd+ | bc)
    echo "sensors transferred: $TOTAL_SENSORS" 1>&2
    echo "context=migration_$SUFFIX&sensor=shards_processed $PROCESSED"
    echo "context=migration_$SUFFIX&sensor=sensors_processed $TOTAL_SENSORS"
}

func() {
    {
        echo '{'
        echo '"commonLabels": {'
        echo '    "project": "junk",'
        echo '    "cluster": "foo",'
        echo '    "service": "bar"'
        echo '  }, "sensors": ['

        while read line; do
            args=$(echo $line | awk '{ print $1}')
            val=$(echo $line | awk '{ print $2}')

            labels=$(echo "\"$args\"" | sed -e "s/=/\": \"/g; s/&/\", \"/g")
            echo '{'
            echo "\"labels\": { $labels },"
            echo "\"value\": \"$val\""
            echo -n "},"
        done
        echo ']}'
    } | sed -e "s/,]/]/g" | jq .
}

check() {
    data="$(check_impl | func)"
    echo "$data" > ./stamp
    echo

    curl -s -H "Content-Type: application/json" --data "${data}" http://api.solomon-test.search.yandex.net/push/json
}

check

#useful debug functions are commented out:
#tails
#tails_alive
