#!/bin/bash -e

. "$(dirname $0)/config.sh"
cd "$(dirname $0)/libs"
CP="."

START=$(date)
MEM=200
foo() {
    CLASS_PATH="${REMOTE_WORKDIR}/libs/*"
    java \
        -classpath "${CLASS_PATH}" \
        -server \
        -Xmx${MEM}g \
        -Xms${MEM}g \
        -classpath "${CLASS_PATH}" \
        -XX:-OmitStackTraceInFastThrow \
        -XX:+PreserveFramePointer \
        -Dru.yandex.solomon.LabelValidator=skip \
        ru.yandex.solomon.tool.migration.kv.MetabaseTransfer \
        --source $SOURCE_METABASE \
        --target $TARGET_METABASE $@

    echo
    echo "start: $START"
    echo "end:   $(date)"
}

foo $@ | tee ~/migrate/output
