#!/bin/bash -e

PERIOD=0

WD=$(cd $(dirname $0); pwd)
. "${WD}/config.sh"

REMOTE_LOG=${REMOTE_WORKDIR}/mig_mb_log.txt

echo "Stopping old jobs..."
parallel-ssh -i -H "${TARGET_METABASE_HOSTS}" "ps -o 'pid,cmd' -C java | grep MetabaseTransfer | awk '{ print \$1 }' | while read PID; do sudo kill -9 \$PID; done; rm -f $REMOTE_LOG;"
sleep 3 # for some reason killing takes some time
echo "Starting new jobs..."
parallel-ssh -i -H "${TARGET_METABASE_HOSTS}" "${REMOTE_WORKDIR}/run_mb.sh --max-age $PERIOD local > $REMOTE_LOG 2>&1 &"
