#!/bin/bash -e

WD=$(cd $(dirname $0); pwd)
. "${WD}/config.sh"

REMOTE_LOG=${REMOTE_WORKDIR}/mig_sp_log.txt

echo "Stopping old jobs..."
parallel-ssh -i -H "${TARGET_STOCKPILE_HOSTS}" "jps | grep StockpileShardTransfer | awk '{ print \$1 }' | while read PID; do kill -9 \$PID; done; rm -f $REMOTE_LOG;"
echo "Starting new jobs..."
parallel-ssh -i -H "${TARGET_STOCKPILE_HOSTS}" "${REMOTE_WORKDIR}/run_sp.sh --mode migrate local > $REMOTE_LOG 2>&1 &"
