#!/usr/bin/env python3

import os
import json
import datetime as dt
import collections

import urllib.request

import solomon_api

def get_abc_owner(slug, project_id=''):
    headers = {
        "Authorization": "OAuth %s" % os.environ['ABC_TOKEN'],
        "Accept": "application/json",
        "Content-Type": "application/json",
    }

    req = urllib.request.Request('https://abc-back.yandex-team.ru/api/v4/services/?slug=%s&fields=owner' % slug, headers=headers)
    result = json.load(urllib.request.urlopen(req))['results']
    owner = ""
    if result:
        owner = result[0].get("owner", "")
        if owner:
           owner = owner.get("login", "")
        else:
            print("# Empty owner in ABC for slug %s (project %s)" % (slug, project_id))
            return ""
    else:
        print("# Empty response from ABC for slug %s (project %s)" % (slug, project_id))
    return owner

def main():
    url = "/projects/solomon/sensors/data?maxPoints=500"
    end = dt.datetime.now()
    begin = end - dt.timedelta(days=7)

    data = {
        'program': 'replace_nan({cluster="production", service="gateway", host="cluster", sensor="push.shard.request.count", authType="Anonymous", shardId="total", projectId!="total"}, 0)', 
        "from": begin.strftime("%Y-%m-%dT%H:%M:%S.%fZ"), 
        "to": end.strftime("%Y-%m-%dT%H:%M:%S.%fZ")
        }

    api = solomon_api.V2(os.environ["SOLOMON_TOKEN"])

    resp = api._post_json(url, data)

    abcServices = []
    print("project_id project_owner, rps, abc_service, abc_owner")
    for r in resp['vector']:
        count = len(r['timeseries']['values'])
        if count > 0:
            rps = sum(r['timeseries']['values']) / count 
        else:
            continue
        
        project_id = r['timeseries']['labels']['projectId']

        if rps > 0:
            project = api._get_json("/projects/%s" % project_id)
            solomon_owner = project['owner'] + "@"
            abc_service_slug = project['abcService']
            abc_owner = get_abc_owner(abc_service_slug, project_id) + "@"
            print(project_id, solomon_owner, rps, abc_service_slug, abc_owner)
            abcServices.append(abc_service_slug)

    с = collections.Counter(abcServices)
    print(с.most_common())


if __name__ == "__main__":
    main()
