#!/bin/sh

FOCAL_BOOT_SCRIPT="/usr/share/debootstrap/scripts/focal"
if [ ! -f "$FOCAL_BOOT_SCRIPT" ] ; then
	dpkg -l debootstrap
	ln -vsf gutsy $FOCAL_BOOT_SCRIPT
fi

debootstrap --foreign --variant=minbase --include systemd-sysv,tzdata,locales --arch amd64 focal . http://mirror.yandex.ru/ubuntu

# Do not mknod/mount/umount anything
tee -a debootstrap/functions <<EOF
mknod () { warning "" "skip mknod \$*"; }
mount () { warning "" "skip mount \$*"; }
umount () { warning "" "skip umount \$*"; }
EOF
